/*
 * Decompiled with CFR 0.152.
 */
package com.primeton.pmq.management;

import com.primeton.pmq.PMQConnection;
import com.primeton.pmq.management.JMSConnectionStatsImpl;
import com.primeton.pmq.management.StatsImpl;
import com.primeton.pmq.util.IndentPrinter;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public class JMSStatsImpl
extends StatsImpl {
    private List<PMQConnection> connections = new CopyOnWriteArrayList<PMQConnection>();

    public JMSConnectionStatsImpl[] getConnections() {
        Object[] connectionArray = this.connections.toArray();
        int size2 = connectionArray.length;
        JMSConnectionStatsImpl[] answer = new JMSConnectionStatsImpl[size2];
        for (int i = 0; i < size2; ++i) {
            PMQConnection connection = (PMQConnection)connectionArray[i];
            answer[i] = connection.getConnectionStats();
        }
        return answer;
    }

    public void addConnection(PMQConnection connection) {
        this.connections.add(connection);
    }

    public void removeConnection(PMQConnection connection) {
        this.connections.remove(connection);
    }

    public void dump(IndentPrinter out) {
        out.printIndent();
        out.println("factory {");
        out.incrementIndent();
        JMSConnectionStatsImpl[] array = this.getConnections();
        for (int i = 0; i < array.length; ++i) {
            JMSConnectionStatsImpl connectionStat = array[i];
            connectionStat.dump(out);
        }
        out.decrementIndent();
        out.printIndent();
        out.println("}");
        out.flush();
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        JMSConnectionStatsImpl[] stats = this.getConnections();
        int size2 = stats.length;
        for (int i = 0; i < size2; ++i) {
            stats[i].setEnabled(enabled);
        }
    }
}

