/*
 * Decompiled with CFR 0.152.
 */
package com.primeton.pmq.openwire.v10;

import com.primeton.pmq.openwire.DataStreamMarshaller;
import com.primeton.pmq.openwire.OpenWireFormat;
import com.primeton.pmq.openwire.v10.BrokerIdMarshaller;
import com.primeton.pmq.openwire.v10.BrokerInfoMarshaller;
import com.primeton.pmq.openwire.v10.ConnectionControlMarshaller;
import com.primeton.pmq.openwire.v10.ConnectionErrorMarshaller;
import com.primeton.pmq.openwire.v10.ConnectionIdMarshaller;
import com.primeton.pmq.openwire.v10.ConnectionInfoMarshaller;
import com.primeton.pmq.openwire.v10.ConsumerControlMarshaller;
import com.primeton.pmq.openwire.v10.ConsumerIdMarshaller;
import com.primeton.pmq.openwire.v10.ConsumerInfoMarshaller;
import com.primeton.pmq.openwire.v10.ControlCommandMarshaller;
import com.primeton.pmq.openwire.v10.DataArrayResponseMarshaller;
import com.primeton.pmq.openwire.v10.DataResponseMarshaller;
import com.primeton.pmq.openwire.v10.DestinationInfoMarshaller;
import com.primeton.pmq.openwire.v10.DiscoveryEventMarshaller;
import com.primeton.pmq.openwire.v10.ExceptionResponseMarshaller;
import com.primeton.pmq.openwire.v10.FlushCommandMarshaller;
import com.primeton.pmq.openwire.v10.IntegerResponseMarshaller;
import com.primeton.pmq.openwire.v10.JournalQueueAckMarshaller;
import com.primeton.pmq.openwire.v10.JournalTopicAckMarshaller;
import com.primeton.pmq.openwire.v10.JournalTraceMarshaller;
import com.primeton.pmq.openwire.v10.JournalTransactionMarshaller;
import com.primeton.pmq.openwire.v10.KeepAliveInfoMarshaller;
import com.primeton.pmq.openwire.v10.LastPartialCommandMarshaller;
import com.primeton.pmq.openwire.v10.LocalTransactionIdMarshaller;
import com.primeton.pmq.openwire.v10.MessageAckMarshaller;
import com.primeton.pmq.openwire.v10.MessageDispatchMarshaller;
import com.primeton.pmq.openwire.v10.MessageDispatchNotificationMarshaller;
import com.primeton.pmq.openwire.v10.MessageIdMarshaller;
import com.primeton.pmq.openwire.v10.MessagePullMarshaller;
import com.primeton.pmq.openwire.v10.NetworkBridgeFilterMarshaller;
import com.primeton.pmq.openwire.v10.PMQBlobMessageMarshaller;
import com.primeton.pmq.openwire.v10.PMQBytesMessageMarshaller;
import com.primeton.pmq.openwire.v10.PMQMapMessageMarshaller;
import com.primeton.pmq.openwire.v10.PMQMessageMarshaller;
import com.primeton.pmq.openwire.v10.PMQObjectMessageMarshaller;
import com.primeton.pmq.openwire.v10.PMQQueueMarshaller;
import com.primeton.pmq.openwire.v10.PMQStreamMessageMarshaller;
import com.primeton.pmq.openwire.v10.PMQTempQueueMarshaller;
import com.primeton.pmq.openwire.v10.PMQTempTopicMarshaller;
import com.primeton.pmq.openwire.v10.PMQTextMessageMarshaller;
import com.primeton.pmq.openwire.v10.PMQTopicMarshaller;
import com.primeton.pmq.openwire.v10.PartialCommandMarshaller;
import com.primeton.pmq.openwire.v10.ProducerAckMarshaller;
import com.primeton.pmq.openwire.v10.ProducerIdMarshaller;
import com.primeton.pmq.openwire.v10.ProducerInfoMarshaller;
import com.primeton.pmq.openwire.v10.RemoveInfoMarshaller;
import com.primeton.pmq.openwire.v10.RemoveSubscriptionInfoMarshaller;
import com.primeton.pmq.openwire.v10.ReplayCommandMarshaller;
import com.primeton.pmq.openwire.v10.ResponseMarshaller;
import com.primeton.pmq.openwire.v10.SessionIdMarshaller;
import com.primeton.pmq.openwire.v10.SessionInfoMarshaller;
import com.primeton.pmq.openwire.v10.ShutdownInfoMarshaller;
import com.primeton.pmq.openwire.v10.SubscriptionInfoMarshaller;
import com.primeton.pmq.openwire.v10.TransactionInfoMarshaller;
import com.primeton.pmq.openwire.v10.WireFormatInfoMarshaller;
import com.primeton.pmq.openwire.v10.XATransactionIdMarshaller;

public class MarshallerFactory {
    private static final DataStreamMarshaller[] marshaller = new DataStreamMarshaller[256];

    private static void add(DataStreamMarshaller dsm) {
        MarshallerFactory.marshaller[dsm.getDataStructureType()] = dsm;
    }

    public static DataStreamMarshaller[] createMarshallerMap(OpenWireFormat wireFormat) {
        return marshaller;
    }

    static {
        MarshallerFactory.add(new PMQBlobMessageMarshaller());
        MarshallerFactory.add(new PMQBytesMessageMarshaller());
        MarshallerFactory.add(new PMQMapMessageMarshaller());
        MarshallerFactory.add(new PMQMessageMarshaller());
        MarshallerFactory.add(new PMQObjectMessageMarshaller());
        MarshallerFactory.add(new PMQQueueMarshaller());
        MarshallerFactory.add(new PMQStreamMessageMarshaller());
        MarshallerFactory.add(new PMQTempQueueMarshaller());
        MarshallerFactory.add(new PMQTempTopicMarshaller());
        MarshallerFactory.add(new PMQTextMessageMarshaller());
        MarshallerFactory.add(new PMQTopicMarshaller());
        MarshallerFactory.add(new BrokerIdMarshaller());
        MarshallerFactory.add(new BrokerInfoMarshaller());
        MarshallerFactory.add(new ConnectionControlMarshaller());
        MarshallerFactory.add(new ConnectionErrorMarshaller());
        MarshallerFactory.add(new ConnectionIdMarshaller());
        MarshallerFactory.add(new ConnectionInfoMarshaller());
        MarshallerFactory.add(new ConsumerControlMarshaller());
        MarshallerFactory.add(new ConsumerIdMarshaller());
        MarshallerFactory.add(new ConsumerInfoMarshaller());
        MarshallerFactory.add(new ControlCommandMarshaller());
        MarshallerFactory.add(new DataArrayResponseMarshaller());
        MarshallerFactory.add(new DataResponseMarshaller());
        MarshallerFactory.add(new DestinationInfoMarshaller());
        MarshallerFactory.add(new DiscoveryEventMarshaller());
        MarshallerFactory.add(new ExceptionResponseMarshaller());
        MarshallerFactory.add(new FlushCommandMarshaller());
        MarshallerFactory.add(new IntegerResponseMarshaller());
        MarshallerFactory.add(new JournalQueueAckMarshaller());
        MarshallerFactory.add(new JournalTopicAckMarshaller());
        MarshallerFactory.add(new JournalTraceMarshaller());
        MarshallerFactory.add(new JournalTransactionMarshaller());
        MarshallerFactory.add(new KeepAliveInfoMarshaller());
        MarshallerFactory.add(new LastPartialCommandMarshaller());
        MarshallerFactory.add(new LocalTransactionIdMarshaller());
        MarshallerFactory.add(new MessageAckMarshaller());
        MarshallerFactory.add(new MessageDispatchMarshaller());
        MarshallerFactory.add(new MessageDispatchNotificationMarshaller());
        MarshallerFactory.add(new MessageIdMarshaller());
        MarshallerFactory.add(new MessagePullMarshaller());
        MarshallerFactory.add(new NetworkBridgeFilterMarshaller());
        MarshallerFactory.add(new PartialCommandMarshaller());
        MarshallerFactory.add(new ProducerAckMarshaller());
        MarshallerFactory.add(new ProducerIdMarshaller());
        MarshallerFactory.add(new ProducerInfoMarshaller());
        MarshallerFactory.add(new RemoveInfoMarshaller());
        MarshallerFactory.add(new RemoveSubscriptionInfoMarshaller());
        MarshallerFactory.add(new ReplayCommandMarshaller());
        MarshallerFactory.add(new ResponseMarshaller());
        MarshallerFactory.add(new SessionIdMarshaller());
        MarshallerFactory.add(new SessionInfoMarshaller());
        MarshallerFactory.add(new ShutdownInfoMarshaller());
        MarshallerFactory.add(new SubscriptionInfoMarshaller());
        MarshallerFactory.add(new TransactionInfoMarshaller());
        MarshallerFactory.add(new WireFormatInfoMarshaller());
        MarshallerFactory.add(new XATransactionIdMarshaller());
    }
}

