/*
 * Decompiled with CFR 0.152.
 */
package com.primeton.pmq.openwire.v5;

import com.primeton.pmq.openwire.DataStreamMarshaller;
import com.primeton.pmq.openwire.OpenWireFormat;
import com.primeton.pmq.openwire.v5.BrokerIdMarshaller;
import com.primeton.pmq.openwire.v5.BrokerInfoMarshaller;
import com.primeton.pmq.openwire.v5.ConnectionControlMarshaller;
import com.primeton.pmq.openwire.v5.ConnectionErrorMarshaller;
import com.primeton.pmq.openwire.v5.ConnectionIdMarshaller;
import com.primeton.pmq.openwire.v5.ConnectionInfoMarshaller;
import com.primeton.pmq.openwire.v5.ConsumerControlMarshaller;
import com.primeton.pmq.openwire.v5.ConsumerIdMarshaller;
import com.primeton.pmq.openwire.v5.ConsumerInfoMarshaller;
import com.primeton.pmq.openwire.v5.ControlCommandMarshaller;
import com.primeton.pmq.openwire.v5.DataArrayResponseMarshaller;
import com.primeton.pmq.openwire.v5.DataResponseMarshaller;
import com.primeton.pmq.openwire.v5.DestinationInfoMarshaller;
import com.primeton.pmq.openwire.v5.DiscoveryEventMarshaller;
import com.primeton.pmq.openwire.v5.ExceptionResponseMarshaller;
import com.primeton.pmq.openwire.v5.FlushCommandMarshaller;
import com.primeton.pmq.openwire.v5.IntegerResponseMarshaller;
import com.primeton.pmq.openwire.v5.JournalQueueAckMarshaller;
import com.primeton.pmq.openwire.v5.JournalTopicAckMarshaller;
import com.primeton.pmq.openwire.v5.JournalTraceMarshaller;
import com.primeton.pmq.openwire.v5.JournalTransactionMarshaller;
import com.primeton.pmq.openwire.v5.KeepAliveInfoMarshaller;
import com.primeton.pmq.openwire.v5.LastPartialCommandMarshaller;
import com.primeton.pmq.openwire.v5.LocalTransactionIdMarshaller;
import com.primeton.pmq.openwire.v5.MessageAckMarshaller;
import com.primeton.pmq.openwire.v5.MessageDispatchMarshaller;
import com.primeton.pmq.openwire.v5.MessageDispatchNotificationMarshaller;
import com.primeton.pmq.openwire.v5.MessageIdMarshaller;
import com.primeton.pmq.openwire.v5.MessagePullMarshaller;
import com.primeton.pmq.openwire.v5.NetworkBridgeFilterMarshaller;
import com.primeton.pmq.openwire.v5.PMQBlobMessageMarshaller;
import com.primeton.pmq.openwire.v5.PMQBytesMessageMarshaller;
import com.primeton.pmq.openwire.v5.PMQMapMessageMarshaller;
import com.primeton.pmq.openwire.v5.PMQMessageMarshaller;
import com.primeton.pmq.openwire.v5.PMQObjectMessageMarshaller;
import com.primeton.pmq.openwire.v5.PMQQueueMarshaller;
import com.primeton.pmq.openwire.v5.PMQStreamMessageMarshaller;
import com.primeton.pmq.openwire.v5.PMQTempQueueMarshaller;
import com.primeton.pmq.openwire.v5.PMQTempTopicMarshaller;
import com.primeton.pmq.openwire.v5.PMQTextMessageMarshaller;
import com.primeton.pmq.openwire.v5.PMQTopicMarshaller;
import com.primeton.pmq.openwire.v5.PartialCommandMarshaller;
import com.primeton.pmq.openwire.v5.ProducerAckMarshaller;
import com.primeton.pmq.openwire.v5.ProducerIdMarshaller;
import com.primeton.pmq.openwire.v5.ProducerInfoMarshaller;
import com.primeton.pmq.openwire.v5.RemoveInfoMarshaller;
import com.primeton.pmq.openwire.v5.RemoveSubscriptionInfoMarshaller;
import com.primeton.pmq.openwire.v5.ReplayCommandMarshaller;
import com.primeton.pmq.openwire.v5.ResponseMarshaller;
import com.primeton.pmq.openwire.v5.SessionIdMarshaller;
import com.primeton.pmq.openwire.v5.SessionInfoMarshaller;
import com.primeton.pmq.openwire.v5.ShutdownInfoMarshaller;
import com.primeton.pmq.openwire.v5.SubscriptionInfoMarshaller;
import com.primeton.pmq.openwire.v5.TransactionInfoMarshaller;
import com.primeton.pmq.openwire.v5.WireFormatInfoMarshaller;
import com.primeton.pmq.openwire.v5.XATransactionIdMarshaller;

public class MarshallerFactory {
    private static final DataStreamMarshaller[] marshaller = new DataStreamMarshaller[256];

    private static void add(DataStreamMarshaller dsm) {
        MarshallerFactory.marshaller[dsm.getDataStructureType()] = dsm;
    }

    public static DataStreamMarshaller[] createMarshallerMap(OpenWireFormat wireFormat) {
        return marshaller;
    }

    static {
        MarshallerFactory.add(new PMQBlobMessageMarshaller());
        MarshallerFactory.add(new PMQBytesMessageMarshaller());
        MarshallerFactory.add(new PMQMapMessageMarshaller());
        MarshallerFactory.add(new PMQMessageMarshaller());
        MarshallerFactory.add(new PMQObjectMessageMarshaller());
        MarshallerFactory.add(new PMQQueueMarshaller());
        MarshallerFactory.add(new PMQStreamMessageMarshaller());
        MarshallerFactory.add(new PMQTempQueueMarshaller());
        MarshallerFactory.add(new PMQTempTopicMarshaller());
        MarshallerFactory.add(new PMQTextMessageMarshaller());
        MarshallerFactory.add(new PMQTopicMarshaller());
        MarshallerFactory.add(new BrokerIdMarshaller());
        MarshallerFactory.add(new BrokerInfoMarshaller());
        MarshallerFactory.add(new ConnectionControlMarshaller());
        MarshallerFactory.add(new ConnectionErrorMarshaller());
        MarshallerFactory.add(new ConnectionIdMarshaller());
        MarshallerFactory.add(new ConnectionInfoMarshaller());
        MarshallerFactory.add(new ConsumerControlMarshaller());
        MarshallerFactory.add(new ConsumerIdMarshaller());
        MarshallerFactory.add(new ConsumerInfoMarshaller());
        MarshallerFactory.add(new ControlCommandMarshaller());
        MarshallerFactory.add(new DataArrayResponseMarshaller());
        MarshallerFactory.add(new DataResponseMarshaller());
        MarshallerFactory.add(new DestinationInfoMarshaller());
        MarshallerFactory.add(new DiscoveryEventMarshaller());
        MarshallerFactory.add(new ExceptionResponseMarshaller());
        MarshallerFactory.add(new FlushCommandMarshaller());
        MarshallerFactory.add(new IntegerResponseMarshaller());
        MarshallerFactory.add(new JournalQueueAckMarshaller());
        MarshallerFactory.add(new JournalTopicAckMarshaller());
        MarshallerFactory.add(new JournalTraceMarshaller());
        MarshallerFactory.add(new JournalTransactionMarshaller());
        MarshallerFactory.add(new KeepAliveInfoMarshaller());
        MarshallerFactory.add(new LastPartialCommandMarshaller());
        MarshallerFactory.add(new LocalTransactionIdMarshaller());
        MarshallerFactory.add(new MessageAckMarshaller());
        MarshallerFactory.add(new MessageDispatchMarshaller());
        MarshallerFactory.add(new MessageDispatchNotificationMarshaller());
        MarshallerFactory.add(new MessageIdMarshaller());
        MarshallerFactory.add(new MessagePullMarshaller());
        MarshallerFactory.add(new NetworkBridgeFilterMarshaller());
        MarshallerFactory.add(new PartialCommandMarshaller());
        MarshallerFactory.add(new ProducerAckMarshaller());
        MarshallerFactory.add(new ProducerIdMarshaller());
        MarshallerFactory.add(new ProducerInfoMarshaller());
        MarshallerFactory.add(new RemoveInfoMarshaller());
        MarshallerFactory.add(new RemoveSubscriptionInfoMarshaller());
        MarshallerFactory.add(new ReplayCommandMarshaller());
        MarshallerFactory.add(new ResponseMarshaller());
        MarshallerFactory.add(new SessionIdMarshaller());
        MarshallerFactory.add(new SessionInfoMarshaller());
        MarshallerFactory.add(new ShutdownInfoMarshaller());
        MarshallerFactory.add(new SubscriptionInfoMarshaller());
        MarshallerFactory.add(new TransactionInfoMarshaller());
        MarshallerFactory.add(new WireFormatInfoMarshaller());
        MarshallerFactory.add(new XATransactionIdMarshaller());
    }
}

