/*
 * Decompiled with CFR 0.152.
 */
package com.primeton.pmq.openwire.v7;

import com.primeton.pmq.openwire.DataStreamMarshaller;
import com.primeton.pmq.openwire.OpenWireFormat;
import com.primeton.pmq.openwire.v7.BrokerIdMarshaller;
import com.primeton.pmq.openwire.v7.BrokerInfoMarshaller;
import com.primeton.pmq.openwire.v7.ConnectionControlMarshaller;
import com.primeton.pmq.openwire.v7.ConnectionErrorMarshaller;
import com.primeton.pmq.openwire.v7.ConnectionIdMarshaller;
import com.primeton.pmq.openwire.v7.ConnectionInfoMarshaller;
import com.primeton.pmq.openwire.v7.ConsumerControlMarshaller;
import com.primeton.pmq.openwire.v7.ConsumerIdMarshaller;
import com.primeton.pmq.openwire.v7.ConsumerInfoMarshaller;
import com.primeton.pmq.openwire.v7.ControlCommandMarshaller;
import com.primeton.pmq.openwire.v7.DataArrayResponseMarshaller;
import com.primeton.pmq.openwire.v7.DataResponseMarshaller;
import com.primeton.pmq.openwire.v7.DestinationInfoMarshaller;
import com.primeton.pmq.openwire.v7.DiscoveryEventMarshaller;
import com.primeton.pmq.openwire.v7.ExceptionResponseMarshaller;
import com.primeton.pmq.openwire.v7.FlushCommandMarshaller;
import com.primeton.pmq.openwire.v7.IntegerResponseMarshaller;
import com.primeton.pmq.openwire.v7.JournalQueueAckMarshaller;
import com.primeton.pmq.openwire.v7.JournalTopicAckMarshaller;
import com.primeton.pmq.openwire.v7.JournalTraceMarshaller;
import com.primeton.pmq.openwire.v7.JournalTransactionMarshaller;
import com.primeton.pmq.openwire.v7.KeepAliveInfoMarshaller;
import com.primeton.pmq.openwire.v7.LastPartialCommandMarshaller;
import com.primeton.pmq.openwire.v7.LocalTransactionIdMarshaller;
import com.primeton.pmq.openwire.v7.MessageAckMarshaller;
import com.primeton.pmq.openwire.v7.MessageDispatchMarshaller;
import com.primeton.pmq.openwire.v7.MessageDispatchNotificationMarshaller;
import com.primeton.pmq.openwire.v7.MessageIdMarshaller;
import com.primeton.pmq.openwire.v7.MessagePullMarshaller;
import com.primeton.pmq.openwire.v7.NetworkBridgeFilterMarshaller;
import com.primeton.pmq.openwire.v7.PMQBlobMessageMarshaller;
import com.primeton.pmq.openwire.v7.PMQBytesMessageMarshaller;
import com.primeton.pmq.openwire.v7.PMQMapMessageMarshaller;
import com.primeton.pmq.openwire.v7.PMQMessageMarshaller;
import com.primeton.pmq.openwire.v7.PMQObjectMessageMarshaller;
import com.primeton.pmq.openwire.v7.PMQQueueMarshaller;
import com.primeton.pmq.openwire.v7.PMQStreamMessageMarshaller;
import com.primeton.pmq.openwire.v7.PMQTempQueueMarshaller;
import com.primeton.pmq.openwire.v7.PMQTempTopicMarshaller;
import com.primeton.pmq.openwire.v7.PMQTextMessageMarshaller;
import com.primeton.pmq.openwire.v7.PMQTopicMarshaller;
import com.primeton.pmq.openwire.v7.PartialCommandMarshaller;
import com.primeton.pmq.openwire.v7.ProducerAckMarshaller;
import com.primeton.pmq.openwire.v7.ProducerIdMarshaller;
import com.primeton.pmq.openwire.v7.ProducerInfoMarshaller;
import com.primeton.pmq.openwire.v7.RemoveInfoMarshaller;
import com.primeton.pmq.openwire.v7.RemoveSubscriptionInfoMarshaller;
import com.primeton.pmq.openwire.v7.ReplayCommandMarshaller;
import com.primeton.pmq.openwire.v7.ResponseMarshaller;
import com.primeton.pmq.openwire.v7.SessionIdMarshaller;
import com.primeton.pmq.openwire.v7.SessionInfoMarshaller;
import com.primeton.pmq.openwire.v7.ShutdownInfoMarshaller;
import com.primeton.pmq.openwire.v7.SubscriptionInfoMarshaller;
import com.primeton.pmq.openwire.v7.TransactionInfoMarshaller;
import com.primeton.pmq.openwire.v7.WireFormatInfoMarshaller;
import com.primeton.pmq.openwire.v7.XATransactionIdMarshaller;

public class MarshallerFactory {
    private static final DataStreamMarshaller[] marshaller = new DataStreamMarshaller[256];

    private static void add(DataStreamMarshaller dsm) {
        MarshallerFactory.marshaller[dsm.getDataStructureType()] = dsm;
    }

    public static DataStreamMarshaller[] createMarshallerMap(OpenWireFormat wireFormat) {
        return marshaller;
    }

    static {
        MarshallerFactory.add(new PMQBlobMessageMarshaller());
        MarshallerFactory.add(new PMQBytesMessageMarshaller());
        MarshallerFactory.add(new PMQMapMessageMarshaller());
        MarshallerFactory.add(new PMQMessageMarshaller());
        MarshallerFactory.add(new PMQObjectMessageMarshaller());
        MarshallerFactory.add(new PMQQueueMarshaller());
        MarshallerFactory.add(new PMQStreamMessageMarshaller());
        MarshallerFactory.add(new PMQTempQueueMarshaller());
        MarshallerFactory.add(new PMQTempTopicMarshaller());
        MarshallerFactory.add(new PMQTextMessageMarshaller());
        MarshallerFactory.add(new PMQTopicMarshaller());
        MarshallerFactory.add(new BrokerIdMarshaller());
        MarshallerFactory.add(new BrokerInfoMarshaller());
        MarshallerFactory.add(new ConnectionControlMarshaller());
        MarshallerFactory.add(new ConnectionErrorMarshaller());
        MarshallerFactory.add(new ConnectionIdMarshaller());
        MarshallerFactory.add(new ConnectionInfoMarshaller());
        MarshallerFactory.add(new ConsumerControlMarshaller());
        MarshallerFactory.add(new ConsumerIdMarshaller());
        MarshallerFactory.add(new ConsumerInfoMarshaller());
        MarshallerFactory.add(new ControlCommandMarshaller());
        MarshallerFactory.add(new DataArrayResponseMarshaller());
        MarshallerFactory.add(new DataResponseMarshaller());
        MarshallerFactory.add(new DestinationInfoMarshaller());
        MarshallerFactory.add(new DiscoveryEventMarshaller());
        MarshallerFactory.add(new ExceptionResponseMarshaller());
        MarshallerFactory.add(new FlushCommandMarshaller());
        MarshallerFactory.add(new IntegerResponseMarshaller());
        MarshallerFactory.add(new JournalQueueAckMarshaller());
        MarshallerFactory.add(new JournalTopicAckMarshaller());
        MarshallerFactory.add(new JournalTraceMarshaller());
        MarshallerFactory.add(new JournalTransactionMarshaller());
        MarshallerFactory.add(new KeepAliveInfoMarshaller());
        MarshallerFactory.add(new LastPartialCommandMarshaller());
        MarshallerFactory.add(new LocalTransactionIdMarshaller());
        MarshallerFactory.add(new MessageAckMarshaller());
        MarshallerFactory.add(new MessageDispatchMarshaller());
        MarshallerFactory.add(new MessageDispatchNotificationMarshaller());
        MarshallerFactory.add(new MessageIdMarshaller());
        MarshallerFactory.add(new MessagePullMarshaller());
        MarshallerFactory.add(new NetworkBridgeFilterMarshaller());
        MarshallerFactory.add(new PartialCommandMarshaller());
        MarshallerFactory.add(new ProducerAckMarshaller());
        MarshallerFactory.add(new ProducerIdMarshaller());
        MarshallerFactory.add(new ProducerInfoMarshaller());
        MarshallerFactory.add(new RemoveInfoMarshaller());
        MarshallerFactory.add(new RemoveSubscriptionInfoMarshaller());
        MarshallerFactory.add(new ReplayCommandMarshaller());
        MarshallerFactory.add(new ResponseMarshaller());
        MarshallerFactory.add(new SessionIdMarshaller());
        MarshallerFactory.add(new SessionInfoMarshaller());
        MarshallerFactory.add(new ShutdownInfoMarshaller());
        MarshallerFactory.add(new SubscriptionInfoMarshaller());
        MarshallerFactory.add(new TransactionInfoMarshaller());
        MarshallerFactory.add(new WireFormatInfoMarshaller());
        MarshallerFactory.add(new XATransactionIdMarshaller());
    }
}

