/*
 * Decompiled with CFR 0.152.
 */
package com.primeton.pmq.openwire.v7;

import com.primeton.pmq.command.DataStructure;
import com.primeton.pmq.command.PMQBlobMessage;
import com.primeton.pmq.openwire.BooleanStream;
import com.primeton.pmq.openwire.OpenWireFormat;
import com.primeton.pmq.openwire.v7.PMQMessageMarshaller;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class PMQBlobMessageMarshaller
extends PMQMessageMarshaller {
    @Override
    public byte getDataStructureType() {
        return 29;
    }

    @Override
    public DataStructure createObject() {
        return new PMQBlobMessage();
    }

    @Override
    public void tightUnmarshal(OpenWireFormat wireFormat, Object o, DataInput dataIn, BooleanStream bs) throws IOException {
        super.tightUnmarshal(wireFormat, o, dataIn, bs);
        PMQBlobMessage info = (PMQBlobMessage)o;
        info.setRemoteBlobUrl(this.tightUnmarshalString(dataIn, bs));
        info.setMimeType(this.tightUnmarshalString(dataIn, bs));
        info.setDeletedByBroker(bs.readBoolean());
    }

    @Override
    public int tightMarshal1(OpenWireFormat wireFormat, Object o, BooleanStream bs) throws IOException {
        PMQBlobMessage info = (PMQBlobMessage)o;
        int rc = super.tightMarshal1(wireFormat, o, bs);
        rc += this.tightMarshalString1(info.getRemoteBlobUrl(), bs);
        bs.writeBoolean(info.isDeletedByBroker());
        return (rc += this.tightMarshalString1(info.getMimeType(), bs)) + 0;
    }

    @Override
    public void tightMarshal2(OpenWireFormat wireFormat, Object o, DataOutput dataOut, BooleanStream bs) throws IOException {
        super.tightMarshal2(wireFormat, o, dataOut, bs);
        PMQBlobMessage info = (PMQBlobMessage)o;
        this.tightMarshalString2(info.getRemoteBlobUrl(), dataOut, bs);
        this.tightMarshalString2(info.getMimeType(), dataOut, bs);
        bs.readBoolean();
    }

    @Override
    public void looseUnmarshal(OpenWireFormat wireFormat, Object o, DataInput dataIn) throws IOException {
        super.looseUnmarshal(wireFormat, o, dataIn);
        PMQBlobMessage info = (PMQBlobMessage)o;
        info.setRemoteBlobUrl(this.looseUnmarshalString(dataIn));
        info.setMimeType(this.looseUnmarshalString(dataIn));
        info.setDeletedByBroker(dataIn.readBoolean());
    }

    @Override
    public void looseMarshal(OpenWireFormat wireFormat, Object o, DataOutput dataOut) throws IOException {
        PMQBlobMessage info = (PMQBlobMessage)o;
        super.looseMarshal(wireFormat, o, dataOut);
        this.looseMarshalString(info.getRemoteBlobUrl(), dataOut);
        this.looseMarshalString(info.getMimeType(), dataOut);
        dataOut.writeBoolean(info.isDeletedByBroker());
    }
}

