/*
 * Decompiled with CFR 0.152.
 */
package com.primeton.pmq.security;

import com.primeton.pmq.broker.ConnectionContext;
import com.primeton.pmq.broker.region.Destination;
import com.primeton.pmq.broker.region.DestinationFilter;
import com.primeton.pmq.broker.region.Subscription;
import com.primeton.pmq.command.PMQDestination;
import com.primeton.pmq.security.AuthorizationBroker;
import com.primeton.pmq.security.AuthorizationMap;
import com.primeton.pmq.security.SecurityContext;
import java.util.Set;

public class AuthorizationDestinationFilter
extends DestinationFilter {
    private final AuthorizationBroker broker;

    public AuthorizationDestinationFilter(Destination destination, AuthorizationBroker broker) {
        super(destination);
        this.broker = broker;
    }

    @Override
    public void addSubscription(ConnectionContext context, Subscription sub) throws Exception {
        SecurityContext securityContext = this.broker.checkSecurityContext(context);
        AuthorizationMap authorizationMap = this.broker.getAuthorizationMap();
        PMQDestination destination = this.next.getPMQDestination();
        Set<?> allowedACLs = !destination.isTemporary() ? authorizationMap.getReadACLs(destination) : authorizationMap.getTempDestinationReadACLs();
        if (!securityContext.isBrokerContext() && allowedACLs != null && !securityContext.isInOneOf(allowedACLs)) {
            throw new SecurityException("User " + securityContext.getUserName() + " is not authorized to read from: " + destination);
        }
        super.addSubscription(context, sub);
    }
}

