/*
 * Decompiled with CFR 0.152.
 */
package com.primeton.pmq.security.pmq;

import com.primeton.pmq.jaas.GroupPrincipal;
import com.primeton.pmq.security.SecurityContext;
import com.primeton.pmq.security.pmq.AuthenticationAuthorizationEntryFactory;
import com.primeton.pmq.security.pmq.AuthenticationUserManagerMBean;
import com.primeton.pmq.security.pmq.dto.PMQAnonymousUser;
import com.primeton.pmq.security.pmq.dto.PMQAuthenticationUser;
import java.security.Principal;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.stream.Collectors;

public class AuthenticationUserManager
implements AuthenticationUserManagerMBean {
    private final AuthenticationAuthorizationEntryFactory authcAuthzEntryFactory;

    public AuthenticationUserManager(AuthenticationAuthorizationEntryFactory authcAuthzEntryFactory) {
        this.authcAuthzEntryFactory = authcAuthzEntryFactory;
    }

    public SecurityContext authenticate(String username, String password, X509Certificate[] certificates) throws SecurityException {
        SecurityContext securityContext = null;
        if (this.authcAuthzEntryFactory.getAnonymousUser().isAllowed() && username == null && password == null) {
            username = this.authcAuthzEntryFactory.getAnonymousUser().getUsername();
            securityContext = new SecurityContext(username){

                @Override
                public Set<Principal> getPrincipals() {
                    HashSet<Principal> groups = new HashSet<Principal>();
                    groups.add((Principal)new GroupPrincipal(AuthenticationUserManager.this.authcAuthzEntryFactory.getAnonymousUser().getGroup()));
                    return groups;
                }
            };
        } else {
            PMQAuthenticationUser user = this.authcAuthzEntryFactory.getAuthenticationUser(username);
            if (user == null || user.getPassword() == null || !user.getPassword().equals(password)) {
                throw new SecurityException("User name [" + username + "] or password is invalid.");
            }
            final Set<Principal> groups = user.getGroups();
            securityContext = new SecurityContext(username){

                @Override
                public Set<Principal> getPrincipals() {
                    return groups;
                }
            };
        }
        return securityContext;
    }

    @Override
    public void addUser(String username, String password, String groups) {
        PMQAuthenticationUser user = new PMQAuthenticationUser();
        user.setUsername(username);
        user.setPassword(password);
        if (groups != null) {
            StringTokenizer tokenizer = new StringTokenizer(groups, ",");
            while (tokenizer.hasMoreTokens()) {
                user.addGroup(tokenizer.nextToken());
            }
        }
        this.authcAuthzEntryFactory.applyUser(user);
    }

    @Override
    public void deleteUser(String username) {
        this.authcAuthzEntryFactory.deleteUser(username);
    }

    @Override
    public List<Map<String, String>> getUsers() {
        return this.authcAuthzEntryFactory.listUsers().stream().map(u -> {
            HashMap<String, String> user = new HashMap<String, String>();
            user.put("username", u.getUsername());
            user.put("password", u.getPassword());
            user.put("groups", u.getGroupsValue());
            return user;
        }).collect(Collectors.toList());
    }

    @Override
    public void setAnonymousUser(boolean allowed, String username, String group) {
        PMQAnonymousUser anonymousUser = new PMQAnonymousUser();
        anonymousUser.setAllowed(allowed);
        if (username != null) {
            anonymousUser.setUsername(username);
        }
        if (group != null) {
            anonymousUser.setGroup(group);
        }
        this.authcAuthzEntryFactory.setAnonymousUser(anonymousUser);
    }

    public AuthenticationAuthorizationEntryFactory getAuthcAuthzEntryFactory() {
        return this.authcAuthzEntryFactory;
    }
}

