/*
 * Decompiled with CFR 0.152.
 */
package com.primeton.pmq.security.pmq;

import com.primeton.pmq.broker.Broker;
import com.primeton.pmq.broker.jmx.ManagementContext;
import com.primeton.pmq.security.AuthorizationBroker;
import com.primeton.pmq.security.pmq.AuthorizationManager;
import com.primeton.pmq.security.pmq.PMQAuthenticationBroker;
import javax.management.JMException;
import javax.management.ObjectName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PMQAuthorizationBroker
extends AuthorizationBroker {
    private static final Logger logger = LoggerFactory.getLogger(PMQAuthenticationBroker.class);
    private ObjectName objectName;
    private String objectNamePropsAppendage = ",service=AuthorizationManager";
    private final AuthorizationManager authorizationManager;

    public PMQAuthorizationBroker(Broker next, AuthorizationManager authorizationManager) {
        super(next, authorizationManager);
        this.authorizationManager = authorizationManager;
    }

    @Override
    public void start() throws Exception {
        super.start();
        this.registerMbean();
    }

    protected void registerMbean() {
        if (this.getBrokerService().isUseJmx()) {
            ManagementContext managementContext = this.getBrokerService().getManagementContext();
            try {
                this.objectName = new ObjectName(this.getBrokerService().getBrokerObjectName().toString() + this.objectNamePropsAppendage);
                managementContext.registerMBean(this.authorizationManager, this.objectName);
            }
            catch (Exception ignored) {
                logger.debug("failed to register AuthorizationManagerMBean", (Throwable)ignored);
            }
        }
    }

    protected void unregisterMbean() {
        if (this.objectName != null) {
            try {
                this.getBrokerService().getManagementContext().unregisterMBean(this.objectName);
            }
            catch (JMException jMException) {
                // empty catch block
            }
        }
    }
}

