/*
 * Decompiled with CFR 0.152.
 */
package com.primeton.pmq.spring;

import com.primeton.pmq.broker.SslContext;
import com.primeton.pmq.spring.Utils;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.Security;
import java.security.cert.CRL;
import java.security.cert.CertSelector;
import java.security.cert.CertStore;
import java.security.cert.CertificateFactory;
import java.security.cert.CollectionCertStoreParameters;
import java.security.cert.PKIXBuilderParameters;
import java.security.cert.X509CertSelector;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import javax.annotation.PostConstruct;
import javax.net.ssl.CertPathTrustManagerParameters;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;

public class SpringSslContext
extends SslContext {
    private static final transient Logger LOG = LoggerFactory.getLogger(SpringSslContext.class);
    private String keyStoreType = "jks";
    private String trustStoreType = "jks";
    private String secureRandomAlgorithm = "SHA1PRNG";
    private String keyStoreAlgorithm = KeyManagerFactory.getDefaultAlgorithm();
    private String trustStoreAlgorithm = TrustManagerFactory.getDefaultAlgorithm();
    private String keyStore;
    private String trustStore;
    private String keyStoreKeyPassword;
    private String keyStorePassword;
    private String trustStorePassword;
    private String crlPath;

    @PostConstruct
    private void postConstruct() {
        try {
            this.afterPropertiesSet();
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public void afterPropertiesSet() throws Exception {
        this.keyManagers.addAll(this.createKeyManagers());
        this.trustManagers.addAll(this.createTrustManagers());
        if (this.secureRandom == null) {
            this.secureRandom = this.createSecureRandom();
        }
    }

    private SecureRandom createSecureRandom() throws NoSuchAlgorithmException {
        return SecureRandom.getInstance(this.secureRandomAlgorithm);
    }

    private Collection<TrustManager> createTrustManagers() throws Exception {
        boolean ocsp = Boolean.valueOf(Security.getProperty("ocsp.enable"));
        KeyStore ks = this.createTrustManagerKeyStore();
        if (ks == null) {
            return new ArrayList<TrustManager>(0);
        }
        TrustManagerFactory tmf = TrustManagerFactory.getInstance(this.trustStoreAlgorithm);
        boolean initialized = false;
        if ((ocsp || this.crlPath != null) && this.trustStoreAlgorithm.equalsIgnoreCase("PKIX")) {
            PKIXBuilderParameters pkixParams = new PKIXBuilderParameters(ks, (CertSelector)new X509CertSelector());
            if (this.crlPath != null) {
                pkixParams.setRevocationEnabled(true);
                Collection<? extends CRL> crlList = this.loadCRL();
                if (crlList != null) {
                    pkixParams.addCertStore(CertStore.getInstance("Collection", new CollectionCertStoreParameters(crlList)));
                }
            }
            tmf.init(new CertPathTrustManagerParameters(pkixParams));
            initialized = true;
        }
        if (!initialized) {
            tmf.init(ks);
        }
        return Arrays.asList(tmf.getTrustManagers());
    }

    private Collection<KeyManager> createKeyManagers() throws Exception {
        KeyStore ks = this.createKeyManagerKeyStore();
        if (ks == null) {
            return new ArrayList<KeyManager>(0);
        }
        KeyManagerFactory tmf = KeyManagerFactory.getInstance(this.keyStoreAlgorithm);
        tmf.init(ks, (char[])(this.keyStoreKeyPassword == null ? (Object)(this.keyStorePassword == null ? null : this.keyStorePassword.toCharArray()) : this.keyStoreKeyPassword.toCharArray()));
        return Arrays.asList(tmf.getKeyManagers());
    }

    private KeyStore createTrustManagerKeyStore() throws Exception {
        if (this.trustStore == null) {
            return null;
        }
        KeyStore ks = KeyStore.getInstance(this.trustStoreType);
        try (InputStream is = Utils.resourceFromString(this.trustStore).getInputStream();){
            ks.load(is, this.trustStorePassword == null ? null : this.trustStorePassword.toCharArray());
        }
        return ks;
    }

    private KeyStore createKeyManagerKeyStore() throws Exception {
        if (this.keyStore == null) {
            return null;
        }
        KeyStore ks = KeyStore.getInstance(this.keyStoreType);
        try (InputStream is = Utils.resourceFromString(this.keyStore).getInputStream();){
            ks.load(is, this.keyStorePassword == null ? null : this.keyStorePassword.toCharArray());
        }
        return ks;
    }

    public String getTrustStoreType() {
        return this.trustStoreType;
    }

    public String getKeyStoreType() {
        return this.keyStoreType;
    }

    public String getKeyStore() {
        return this.keyStore;
    }

    public void setKeyStore(String keyStore) throws MalformedURLException {
        this.keyStore = keyStore;
    }

    public String getTrustStore() {
        return this.trustStore;
    }

    public void setTrustStore(String trustStore) throws MalformedURLException {
        this.trustStore = trustStore;
    }

    public String getKeyStoreAlgorithm() {
        return this.keyStoreAlgorithm;
    }

    public void setKeyStoreAlgorithm(String keyAlgorithm) {
        this.keyStoreAlgorithm = keyAlgorithm;
    }

    public String getTrustStoreAlgorithm() {
        return this.trustStoreAlgorithm;
    }

    public void setTrustStoreAlgorithm(String trustAlgorithm) {
        this.trustStoreAlgorithm = trustAlgorithm;
    }

    public String getKeyStoreKeyPassword() {
        return this.keyStoreKeyPassword;
    }

    public void setKeyStoreKeyPassword(String keyPassword) {
        this.keyStoreKeyPassword = keyPassword;
    }

    public String getKeyStorePassword() {
        return this.keyStorePassword;
    }

    public void setKeyStorePassword(String keyPassword) {
        this.keyStorePassword = keyPassword;
    }

    public String getTrustStorePassword() {
        return this.trustStorePassword;
    }

    public void setTrustStorePassword(String trustPassword) {
        this.trustStorePassword = trustPassword;
    }

    public void setKeyStoreType(String keyType) {
        this.keyStoreType = keyType;
    }

    public void setTrustStoreType(String trustType) {
        this.trustStoreType = trustType;
    }

    public String getSecureRandomAlgorithm() {
        return this.secureRandomAlgorithm;
    }

    public void setSecureRandomAlgorithm(String secureRandomAlgorithm) {
        this.secureRandomAlgorithm = secureRandomAlgorithm;
    }

    public String getCrlPath() {
        return this.crlPath;
    }

    public void setCrlPath(String crlPath) {
        this.crlPath = crlPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Collection<? extends CRL> loadCRL() throws Exception {
        if (this.crlPath == null) {
            return null;
        }
        Resource resource = Utils.resourceFromString(this.crlPath);
        try (InputStream is = resource.getInputStream();){
            Collection<? extends CRL> collection = CertificateFactory.getInstance("X.509").generateCRLs(is);
            return collection;
        }
    }
}

