/*
 * Decompiled with CFR 0.152.
 */
package com.primeton.pmq.store;

import com.primeton.pmq.broker.ConnectionContext;
import com.primeton.pmq.command.Message;
import com.primeton.pmq.command.MessageAck;
import com.primeton.pmq.command.MessageId;
import com.primeton.pmq.command.PMQDestination;
import com.primeton.pmq.store.IndexListener;
import com.primeton.pmq.store.InlineListenableFuture;
import com.primeton.pmq.store.ListenableFuture;
import com.primeton.pmq.store.MessageStore;
import com.primeton.pmq.store.MessageStoreStatistics;
import com.primeton.pmq.usage.MemoryUsage;
import java.io.IOException;

public abstract class AbstractMessageStore
implements MessageStore {
    public static final ListenableFuture<Object> FUTURE = new InlineListenableFuture();
    protected final PMQDestination destination;
    protected boolean prioritizedMessages;
    protected IndexListener indexListener;
    protected final MessageStoreStatistics messageStoreStatistics = new MessageStoreStatistics();

    public AbstractMessageStore(PMQDestination destination) {
        this.destination = destination;
    }

    @Override
    public void dispose(ConnectionContext context) {
    }

    @Override
    public void start() throws Exception {
        this.recoverMessageStoreStatistics();
    }

    @Override
    public void stop() throws Exception {
    }

    @Override
    public PMQDestination getDestination() {
        return this.destination;
    }

    @Override
    public void setMemoryUsage(MemoryUsage memoryUsage) {
    }

    @Override
    public void setBatch(MessageId messageId) throws IOException, Exception {
    }

    @Override
    public boolean isEmpty() throws Exception {
        return this.getMessageCount() == 0;
    }

    @Override
    public void setPrioritizedMessages(boolean prioritizedMessages) {
        this.prioritizedMessages = prioritizedMessages;
    }

    @Override
    public boolean isPrioritizedMessages() {
        return this.prioritizedMessages;
    }

    @Override
    public void addMessage(ConnectionContext context, Message message, boolean canOptimizeHint) throws IOException {
        this.addMessage(context, message);
    }

    @Override
    public ListenableFuture<Object> asyncAddQueueMessage(ConnectionContext context, Message message) throws IOException {
        this.addMessage(context, message);
        return FUTURE;
    }

    @Override
    public ListenableFuture<Object> asyncAddQueueMessage(ConnectionContext context, Message message, boolean canOptimizeHint) throws IOException {
        this.addMessage(context, message, canOptimizeHint);
        return FUTURE;
    }

    @Override
    public ListenableFuture<Object> asyncAddTopicMessage(ConnectionContext context, Message message, boolean canOptimizeHint) throws IOException {
        this.addMessage(context, message, canOptimizeHint);
        return FUTURE;
    }

    @Override
    public ListenableFuture<Object> asyncAddTopicMessage(ConnectionContext context, Message message) throws IOException {
        this.addMessage(context, message);
        return new InlineListenableFuture();
    }

    @Override
    public void removeAsyncMessage(ConnectionContext context, MessageAck ack) throws IOException {
        this.removeMessage(context, ack);
    }

    @Override
    public void updateMessage(Message message) throws IOException {
        throw new IOException("update is not supported by: " + this);
    }

    @Override
    public void registerIndexListener(IndexListener indexListener) {
        this.indexListener = indexListener;
    }

    public IndexListener getIndexListener() {
        return this.indexListener;
    }

    @Override
    public int getMessageCount() throws IOException {
        return (int)this.getMessageStoreStatistics().getMessageCount().getCount();
    }

    @Override
    public long getMessageSize() throws IOException {
        return this.getMessageStoreStatistics().getMessageSize().getTotalSize();
    }

    @Override
    public MessageStoreStatistics getMessageStoreStatistics() {
        return this.messageStoreStatistics;
    }

    protected void recoverMessageStoreStatistics() throws IOException {
    }
}

