/*
 * Decompiled with CFR 0.152.
 */
package com.primeton.pmq.store.kahadb.disk.journal;

import com.primeton.pmq.store.kahadb.disk.util.LinkedNode;
import com.primeton.pmq.store.kahadb.disk.util.SequenceSet;
import com.primeton.pmq.util.IOHelper;
import com.primeton.pmq.util.RecoverableRandomAccessFile;
import java.io.File;
import java.io.IOException;

public class DataFile
extends LinkedNode<DataFile>
implements Comparable<DataFile> {
    public static final byte STANDARD_LOG_FILE = 0;
    protected final File file;
    protected final Integer dataFileId;
    protected volatile int length;
    protected int typeCode = 0;
    protected final SequenceSet corruptedBlocks = new SequenceSet();
    protected RecoverableRandomAccessFile appendRandomAccessFile;

    DataFile(File file, int number) {
        this.file = file;
        this.dataFileId = number;
        this.length = (int)(file.exists() ? file.length() : 0L);
    }

    public File getFile() {
        return this.file;
    }

    public Integer getDataFileId() {
        return this.dataFileId;
    }

    public int getTypeCode() {
        return this.typeCode;
    }

    public void setTypeCode(int typeCode) {
        this.typeCode = typeCode;
    }

    public synchronized int getLength() {
        return this.length;
    }

    public void setLength(int length) {
        this.length = length;
    }

    public synchronized void incrementLength(int size2) {
        this.length += size2;
    }

    public synchronized void decrementLength(int size2) {
        this.length -= size2;
    }

    public synchronized String toString() {
        return this.file.getName() + " number = " + this.dataFileId + " , length = " + this.length;
    }

    public synchronized RecoverableRandomAccessFile appendRandomAccessFile() throws IOException {
        if (this.appendRandomAccessFile == null) {
            this.appendRandomAccessFile = new RecoverableRandomAccessFile(this.file.getCanonicalPath(), "rw");
        }
        return this.appendRandomAccessFile;
    }

    public synchronized RecoverableRandomAccessFile openRandomAccessFile() throws IOException {
        return new RecoverableRandomAccessFile(this.file.getCanonicalPath(), "rw");
    }

    public synchronized void closeRandomAccessFile(RecoverableRandomAccessFile file) throws IOException {
        file.close();
        if (file == this.appendRandomAccessFile) {
            this.appendRandomAccessFile = null;
        }
    }

    public synchronized boolean delete() throws IOException {
        return this.file.delete();
    }

    public synchronized void move(File targetDirectory) throws IOException {
        IOHelper.moveFile(this.file, targetDirectory);
    }

    public SequenceSet getCorruptedBlocks() {
        return this.corruptedBlocks;
    }

    @Override
    public int compareTo(DataFile df) {
        return this.dataFileId - df.dataFileId;
    }

    public boolean equals(Object o) {
        boolean result = false;
        if (o instanceof DataFile) {
            result = this.compareTo((DataFile)o) == 0;
        }
        return result;
    }

    public int hashCode() {
        return this.dataFileId;
    }
}

