/*
 * Decompiled with CFR 0.152.
 */
package com.primeton.pmq.transport.amqp;

import org.fusesource.hawtbuf.Buffer;

public class AmqpHeader {
    static final Buffer PREFIX = new Buffer(new byte[]{65, 77, 81, 80});
    private Buffer buffer;

    public AmqpHeader() {
        this(new Buffer(new byte[]{65, 77, 81, 80, 0, 1, 0, 0}));
    }

    public AmqpHeader(Buffer buffer) {
        this(buffer, true);
    }

    public AmqpHeader(Buffer buffer, boolean validate) {
        this.setBuffer(buffer, validate);
    }

    public int getProtocolId() {
        return this.buffer.get(4) & 0xFF;
    }

    public void setProtocolId(int value) {
        this.buffer.data[this.buffer.offset + 4] = (byte)value;
    }

    public int getMajor() {
        return this.buffer.get(5) & 0xFF;
    }

    public void setMajor(int value) {
        this.buffer.data[this.buffer.offset + 5] = (byte)value;
    }

    public int getMinor() {
        return this.buffer.get(6) & 0xFF;
    }

    public void setMinor(int value) {
        this.buffer.data[this.buffer.offset + 6] = (byte)value;
    }

    public int getRevision() {
        return this.buffer.get(7) & 0xFF;
    }

    public void setRevision(int value) {
        this.buffer.data[this.buffer.offset + 7] = (byte)value;
    }

    public Buffer getBuffer() {
        return this.buffer;
    }

    public void setBuffer(Buffer value) {
        this.setBuffer(value, true);
    }

    public void setBuffer(Buffer value, boolean validate) {
        if (validate && !value.startsWith(PREFIX) || value.length() != 8) {
            throw new IllegalArgumentException("Not an AMQP header buffer");
        }
        this.buffer = value.buffer();
    }

    public boolean hasValidPrefix() {
        return this.buffer.startsWith(PREFIX);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < this.buffer.length(); ++i) {
            char value = (char)this.buffer.get(i);
            if (Character.isLetter(value)) {
                builder.append(value);
                continue;
            }
            builder.append(",");
            builder.append((int)value);
        }
        return builder.toString();
    }
}

