/*
 * Decompiled with CFR 0.152.
 */
package com.primeton.pmq.transport.amqp;

import com.primeton.pmq.broker.BrokerService;
import com.primeton.pmq.broker.BrokerServiceAware;
import com.primeton.pmq.transport.MutexTransport;
import com.primeton.pmq.transport.Transport;
import com.primeton.pmq.transport.amqp.AmqpInactivityMonitor;
import com.primeton.pmq.transport.amqp.AmqpNioTransport;
import com.primeton.pmq.transport.amqp.AmqpTransportFilter;
import com.primeton.pmq.transport.nio.NIOTransportFactory;
import com.primeton.pmq.transport.tcp.TcpTransport;
import com.primeton.pmq.transport.tcp.TcpTransportServer;
import com.primeton.pmq.util.IntrospectionSupport;
import com.primeton.pmq.wireformat.WireFormat;
import java.io.IOException;
import java.net.Socket;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Map;
import javax.net.ServerSocketFactory;
import javax.net.SocketFactory;

public class AmqpNioTransportFactory
extends NIOTransportFactory
implements BrokerServiceAware {
    private BrokerService brokerService = null;

    @Override
    protected String getDefaultWireFormatType() {
        return "amqp";
    }

    @Override
    protected TcpTransportServer createTcpTransportServer(URI location, ServerSocketFactory serverSocketFactory) throws IOException, URISyntaxException {
        return new TcpTransportServer(this, location, serverSocketFactory){

            @Override
            protected Transport createTransport(Socket socket, WireFormat format2) throws IOException {
                return new AmqpNioTransport(format2, socket);
            }
        };
    }

    @Override
    protected TcpTransport createTcpTransport(WireFormat wf, SocketFactory socketFactory, URI location, URI localLocation) throws UnknownHostException, IOException {
        return new AmqpNioTransport(wf, socketFactory, location, localLocation);
    }

    @Override
    public TcpTransport createTransport(WireFormat wireFormat, Socket socket, TcpTransport.InitBuffer initBuffer) throws IOException {
        return new AmqpNioTransport(wireFormat, socket, initBuffer);
    }

    @Override
    public Transport serverConfigure(Transport transport, WireFormat format2, HashMap options) throws Exception {
        if ((transport = super.serverConfigure(transport, format2, options)) instanceof MutexTransport) {
            transport = ((MutexTransport)transport).getNext();
        }
        return transport;
    }

    @Override
    public Transport compositeConfigure(Transport transport, WireFormat format2, Map options) {
        AmqpTransportFilter amqpTransport = new AmqpTransportFilter(transport, format2, this.brokerService);
        Map<String, Object> wireFormatOptions = IntrospectionSupport.extractProperties(options, "wireFormat.");
        IntrospectionSupport.setProperties(amqpTransport, options);
        IntrospectionSupport.setProperties(amqpTransport.getWireFormat(), wireFormatOptions);
        return super.compositeConfigure(amqpTransport, format2, options);
    }

    @Override
    protected Transport createInactivityMonitor(Transport transport, WireFormat format2) {
        AmqpInactivityMonitor monitor = new AmqpInactivityMonitor(transport, format2);
        AmqpTransportFilter filter = transport.narrow(AmqpTransportFilter.class);
        filter.setInactivityMonitor(monitor);
        return monitor;
    }

    @Override
    public void setBrokerService(BrokerService brokerService) {
        this.brokerService = brokerService;
    }
}

