/*
 * Decompiled with CFR 0.152.
 */
package com.primeton.pmq.transport.amqp;

import com.primeton.pmq.broker.BrokerService;
import com.primeton.pmq.broker.BrokerServiceAware;
import com.primeton.pmq.transport.MutexTransport;
import com.primeton.pmq.transport.Transport;
import com.primeton.pmq.transport.amqp.AmqpInactivityMonitor;
import com.primeton.pmq.transport.amqp.AmqpTransportFilter;
import com.primeton.pmq.transport.tcp.SslTransportFactory;
import com.primeton.pmq.util.IntrospectionSupport;
import com.primeton.pmq.wireformat.WireFormat;
import java.util.HashMap;
import java.util.Map;

public class AmqpSslTransportFactory
extends SslTransportFactory
implements BrokerServiceAware {
    private BrokerService brokerService = null;

    @Override
    protected String getDefaultWireFormatType() {
        return "amqp";
    }

    @Override
    public Transport compositeConfigure(Transport transport, WireFormat format2, Map options) {
        AmqpTransportFilter amqpTransport = new AmqpTransportFilter(transport, format2, this.brokerService);
        Map<String, Object> wireFormatOptions = IntrospectionSupport.extractProperties(options, "wireFormat.");
        IntrospectionSupport.setProperties(amqpTransport, options);
        IntrospectionSupport.setProperties(amqpTransport.getWireFormat(), wireFormatOptions);
        return super.compositeConfigure(amqpTransport, format2, options);
    }

    @Override
    public Transport serverConfigure(Transport transport, WireFormat format2, HashMap options) throws Exception {
        if ((transport = super.serverConfigure(transport, format2, options)) instanceof MutexTransport) {
            transport = ((MutexTransport)transport).getNext();
        }
        return transport;
    }

    @Override
    public void setBrokerService(BrokerService brokerService) {
        this.brokerService = brokerService;
    }

    @Override
    protected Transport createInactivityMonitor(Transport transport, WireFormat format2) {
        AmqpInactivityMonitor monitor = new AmqpInactivityMonitor(transport, format2);
        AmqpTransportFilter filter = transport.narrow(AmqpTransportFilter.class);
        filter.setInactivityMonitor(monitor);
        return monitor;
    }
}

