/*
 * Decompiled with CFR 0.152.
 */
package com.primeton.pmq.transport.amqp;

import com.primeton.pmq.broker.BrokerService;
import com.primeton.pmq.broker.BrokerServiceAware;
import com.primeton.pmq.transport.Transport;
import com.primeton.pmq.transport.TransportFactory;
import com.primeton.pmq.transport.TransportServer;
import com.primeton.pmq.transport.amqp.AmqpInactivityMonitor;
import com.primeton.pmq.transport.amqp.AmqpTransportFilter;
import com.primeton.pmq.transport.amqp.AmqpWSTransport;
import com.primeton.pmq.util.IntrospectionSupport;
import com.primeton.pmq.wireformat.WireFormat;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.UnknownHostException;
import java.util.Map;

public class AmqpWSTransportFactory
extends TransportFactory
implements BrokerServiceAware {
    private BrokerService brokerService = null;

    @Override
    protected String getDefaultWireFormatType() {
        return "amqp";
    }

    @Override
    public TransportServer doBind(URI location) throws IOException {
        throw new IOException("doBind() method not implemented! No Server over WS implemented.");
    }

    @Override
    public Transport compositeConfigure(Transport transport, WireFormat format2, Map options) {
        AmqpTransportFilter amqpTransport = new AmqpTransportFilter(transport, format2, this.brokerService);
        Map<String, Object> wireFormatOptions = IntrospectionSupport.extractProperties(options, "wireFormat.");
        IntrospectionSupport.setProperties(amqpTransport, options);
        IntrospectionSupport.setProperties(amqpTransport.getWireFormat(), wireFormatOptions);
        transport = this.createInactivityMonitor(amqpTransport, format2);
        IntrospectionSupport.setProperties(transport, options);
        return super.compositeConfigure(transport, format2, options);
    }

    @Override
    protected Transport createTransport(URI location, WireFormat wireFormat) throws MalformedURLException, UnknownHostException, IOException {
        return new AmqpWSTransport(location, wireFormat);
    }

    @Override
    public void setBrokerService(BrokerService brokerService) {
        this.brokerService = brokerService;
    }

    protected Transport createInactivityMonitor(AmqpTransportFilter transport, WireFormat format2) {
        AmqpInactivityMonitor monitor = new AmqpInactivityMonitor(transport, format2);
        transport.setInactivityMonitor(monitor);
        return monitor;
    }
}

