/*
 * Decompiled with CFR 0.152.
 */
package com.primeton.pmq.transport.amqp.message;

import com.primeton.pmq.command.ConnectionId;
import com.primeton.pmq.command.ConnectionInfo;
import com.primeton.pmq.command.ConsumerId;
import com.primeton.pmq.command.DataStructure;
import com.primeton.pmq.command.MessageId;
import com.primeton.pmq.command.PMQBytesMessage;
import com.primeton.pmq.command.PMQDestination;
import com.primeton.pmq.command.PMQMapMessage;
import com.primeton.pmq.command.PMQMessage;
import com.primeton.pmq.command.PMQObjectMessage;
import com.primeton.pmq.command.PMQStreamMessage;
import com.primeton.pmq.command.PMQTextMessage;
import com.primeton.pmq.command.RemoveInfo;
import com.primeton.pmq.transport.amqp.AmqpProtocolException;
import com.primeton.pmq.transport.amqp.message.AMQPMessageIdHelper;
import com.primeton.pmq.transport.amqp.message.AmqpMessageSupport;
import com.primeton.pmq.transport.amqp.message.AmqpWritableBuffer;
import com.primeton.pmq.transport.amqp.message.EncodedMessage;
import com.primeton.pmq.transport.amqp.message.OutboundTransformer;
import com.primeton.pmq.transport.amqp.message.UTF8BufferType;
import com.primeton.pmq.util.JMSExceptionSupport;
import com.primeton.pmq.util.TypeConversionSupport;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.jms.JMSException;
import javax.jms.MessageEOFException;
import javax.jms.TextMessage;
import org.apache.qpid.proton.amqp.Binary;
import org.apache.qpid.proton.amqp.Symbol;
import org.apache.qpid.proton.amqp.UnsignedByte;
import org.apache.qpid.proton.amqp.UnsignedInteger;
import org.apache.qpid.proton.amqp.messaging.AmqpSequence;
import org.apache.qpid.proton.amqp.messaging.AmqpValue;
import org.apache.qpid.proton.amqp.messaging.ApplicationProperties;
import org.apache.qpid.proton.amqp.messaging.Data;
import org.apache.qpid.proton.amqp.messaging.DeliveryAnnotations;
import org.apache.qpid.proton.amqp.messaging.Footer;
import org.apache.qpid.proton.amqp.messaging.Header;
import org.apache.qpid.proton.amqp.messaging.MessageAnnotations;
import org.apache.qpid.proton.amqp.messaging.Properties;
import org.apache.qpid.proton.amqp.messaging.Section;
import org.apache.qpid.proton.codec.AMQPDefinedTypes;
import org.apache.qpid.proton.codec.AMQPType;
import org.apache.qpid.proton.codec.Decoder;
import org.apache.qpid.proton.codec.DecoderImpl;
import org.apache.qpid.proton.codec.EncoderImpl;
import org.apache.qpid.proton.codec.WritableBuffer;

public class JMSMappingOutboundTransformer
implements OutboundTransformer {
    public static final Symbol JMS_DEST_TYPE_MSG_ANNOTATION = Symbol.valueOf((String)"x-opt-jms-dest");
    public static final Symbol JMS_REPLY_TO_TYPE_MSG_ANNOTATION = Symbol.valueOf((String)"x-opt-jms-reply-to");
    private static final String AMQ_SCHEDULED_MESSAGE_PREFIX = "AMQ_SCHEDULED_";
    public static final byte QUEUE_TYPE = 0;
    public static final byte TOPIC_TYPE = 1;
    public static final byte TEMP_QUEUE_TYPE = 2;
    public static final byte TEMP_TOPIC_TYPE = 3;
    private final UTF8BufferType utf8BufferEncoding;
    private final DecoderImpl decoder = new DecoderImpl();
    private final EncoderImpl encoder = new EncoderImpl(this.decoder);

    public JMSMappingOutboundTransformer() {
        AMQPDefinedTypes.registerAllTypes((Decoder)this.decoder, (EncoderImpl)this.encoder);
        this.utf8BufferEncoding = new UTF8BufferType(this.encoder, this.decoder);
        this.encoder.register((AMQPType)this.utf8BufferEncoding);
    }

    @Override
    public EncodedMessage transform(PMQMessage message) throws Exception {
        Map<String, Object> entries;
        int groupSequence;
        String groupId;
        String userId;
        int deliveryCount;
        long timeStamp;
        long expiration;
        String correlationId;
        PMQDestination replyTo;
        PMQDestination destination;
        MessageId messageId;
        String type;
        byte priority;
        if (message == null) {
            return null;
        }
        long messageFormat = 0L;
        Header header = null;
        Properties properties = null;
        HashMap<Symbol, Object> daMap = null;
        HashMap<Symbol, Byte> maMap = null;
        HashMap<String, Object> apMap = null;
        HashMap<Symbol, Object> footerMap = null;
        Section body = this.convertBody(message);
        if (message.isPersistent()) {
            if (header == null) {
                header = new Header();
            }
            header.setDurable(Boolean.valueOf(true));
        }
        if ((priority = message.getPriority()) != 4) {
            if (header == null) {
                header = new Header();
            }
            header.setPriority(UnsignedByte.valueOf((byte)priority));
        }
        if ((type = message.getType()) != null) {
            if (properties == null) {
                properties = new Properties();
            }
            properties.setSubject(type);
        }
        if ((messageId = message.getMessageId()) != null) {
            if (properties == null) {
                properties = new Properties();
            }
            properties.setMessageId(JMSMappingOutboundTransformer.getOriginalMessageId(message));
        }
        if ((destination = message.getDestination()) != null) {
            if (properties == null) {
                properties = new Properties();
            }
            properties.setTo(destination.getQualifiedName());
            if (maMap == null) {
                maMap = new HashMap<Symbol, Byte>();
            }
            maMap.put(JMS_DEST_TYPE_MSG_ANNOTATION, JMSMappingOutboundTransformer.destinationType(destination));
        }
        if ((replyTo = message.getReplyTo()) != null) {
            if (properties == null) {
                properties = new Properties();
            }
            properties.setReplyTo(replyTo.getQualifiedName());
            if (maMap == null) {
                maMap = new HashMap();
            }
            maMap.put(JMS_REPLY_TO_TYPE_MSG_ANNOTATION, JMSMappingOutboundTransformer.destinationType(replyTo));
        }
        if ((correlationId = message.getCorrelationId()) != null) {
            if (properties == null) {
                properties = new Properties();
            }
            try {
                properties.setCorrelationId(AMQPMessageIdHelper.INSTANCE.toIdObject(correlationId));
            }
            catch (AmqpProtocolException e) {
                properties.setCorrelationId((Object)correlationId);
            }
        }
        if ((expiration = message.getExpiration()) != 0L) {
            long ttl = expiration - System.currentTimeMillis();
            if (ttl < 0L) {
                ttl = 1L;
            }
            if (header == null) {
                header = new Header();
            }
            header.setTtl(new UnsignedInteger((int)ttl));
            if (properties == null) {
                properties = new Properties();
            }
            properties.setAbsoluteExpiryTime(new Date(expiration));
        }
        if ((timeStamp = message.getTimestamp()) != 0L) {
            if (properties == null) {
                properties = new Properties();
            }
            properties.setCreationTime(new Date(timeStamp));
        }
        if ((deliveryCount = message.getRedeliveryCounter()) > 0) {
            if (header == null) {
                header = new Header();
            }
            header.setDeliveryCount(UnsignedInteger.valueOf((int)deliveryCount));
        }
        if ((userId = message.getUserID()) != null) {
            if (properties == null) {
                properties = new Properties();
            }
            properties.setUserId(new Binary(userId.getBytes(StandardCharsets.UTF_8)));
        }
        if ((groupId = message.getGroupID()) != null) {
            if (properties == null) {
                properties = new Properties();
            }
            properties.setGroupId(groupId);
        }
        if ((groupSequence = message.getGroupSequence()) > 0) {
            if (properties == null) {
                properties = new Properties();
            }
            properties.setGroupSequence(UnsignedInteger.valueOf((int)groupSequence));
        }
        try {
            entries = message.getProperties();
        }
        catch (IOException e) {
            throw JMSExceptionSupport.create(e);
        }
        for (Map.Entry<String, Object> entry : entries.entrySet()) {
            DataStructure data;
            String key = entry.getKey();
            Object value = entry.getValue();
            if (key.startsWith("JMS_AMQP_")) {
                if (key.startsWith("NATIVE", AmqpMessageSupport.JMS_AMQP_PREFIX_LENGTH) || key.startsWith("ORIGINAL_ENCODING", AmqpMessageSupport.JMS_AMQP_PREFIX_LENGTH)) continue;
                if (key.startsWith("MESSAGE_FORMAT", AmqpMessageSupport.JMS_AMQP_PREFIX_LENGTH)) {
                    messageFormat = (Long)TypeConversionSupport.convert(entry.getValue(), Long.class);
                    continue;
                }
                if (key.startsWith("HEADER", AmqpMessageSupport.JMS_AMQP_PREFIX_LENGTH)) {
                    if (header != null) continue;
                    header = new Header();
                    continue;
                }
                if (key.startsWith("PROPERTIES", AmqpMessageSupport.JMS_AMQP_PREFIX_LENGTH)) {
                    if (properties != null) continue;
                    properties = new Properties();
                    continue;
                }
                if (key.startsWith("MA_", AmqpMessageSupport.JMS_AMQP_PREFIX_LENGTH)) {
                    if (maMap == null) {
                        maMap = new HashMap();
                    }
                    String name = key.substring("JMS_AMQP_MA_".length());
                    maMap.put(Symbol.valueOf((String)name), (Byte)value);
                    continue;
                }
                if (key.startsWith("FirstAcquirer", AmqpMessageSupport.JMS_AMQP_PREFIX_LENGTH)) {
                    if (header == null) {
                        header = new Header();
                    }
                    header.setFirstAcquirer(Boolean.valueOf((Boolean)TypeConversionSupport.convert(value, Boolean.class)));
                    continue;
                }
                if (key.startsWith("ContentType", AmqpMessageSupport.JMS_AMQP_PREFIX_LENGTH)) {
                    if (properties == null) {
                        properties = new Properties();
                    }
                    properties.setContentType(Symbol.getSymbol((String)((String)TypeConversionSupport.convert(value, String.class))));
                    continue;
                }
                if (key.startsWith("ContentEncoding", AmqpMessageSupport.JMS_AMQP_PREFIX_LENGTH)) {
                    if (properties == null) {
                        properties = new Properties();
                    }
                    properties.setContentEncoding(Symbol.getSymbol((String)((String)TypeConversionSupport.convert(value, String.class))));
                    continue;
                }
                if (key.startsWith("ReplyToGroupID", AmqpMessageSupport.JMS_AMQP_PREFIX_LENGTH)) {
                    if (properties == null) {
                        properties = new Properties();
                    }
                    properties.setReplyToGroupId((String)TypeConversionSupport.convert(value, String.class));
                    continue;
                }
                if (key.startsWith("DA_", AmqpMessageSupport.JMS_AMQP_PREFIX_LENGTH)) {
                    if (daMap == null) {
                        daMap = new HashMap<Symbol, Object>();
                    }
                    String name = key.substring("JMS_AMQP_DA_".length());
                    daMap.put(Symbol.valueOf((String)name), value);
                    continue;
                }
                if (key.startsWith("FT_", AmqpMessageSupport.JMS_AMQP_PREFIX_LENGTH)) {
                    if (footerMap == null) {
                        footerMap = new HashMap<Symbol, Object>();
                    }
                    String name = key.substring("JMS_AMQP_FT_".length());
                    footerMap.put(Symbol.valueOf((String)name), value);
                    continue;
                }
            } else if (key.startsWith(AMQ_SCHEDULED_MESSAGE_PREFIX)) continue;
            if (apMap == null) {
                apMap = new HashMap<String, Object>();
            }
            apMap.put(key, value);
            byte messageType = message.getDataStructureType();
            if (messageType != 23 || (data = message.getDataStructure()) == null) continue;
            apMap.put("PMQDataStructureType", data.getClass().getSimpleName());
        }
        AmqpWritableBuffer buffer = new AmqpWritableBuffer();
        this.encoder.setByteBuffer((WritableBuffer)buffer);
        if (header != null) {
            this.encoder.writeObject((Object)header);
        }
        if (daMap != null) {
            this.encoder.writeObject((Object)new DeliveryAnnotations(daMap));
        }
        if (maMap != null) {
            this.encoder.writeObject((Object)new MessageAnnotations(maMap));
        }
        if (properties != null) {
            this.encoder.writeObject((Object)properties);
        }
        if (apMap != null) {
            this.encoder.writeObject((Object)new ApplicationProperties(apMap));
        }
        if (body != null) {
            this.encoder.writeObject((Object)body);
        }
        if (footerMap != null) {
            this.encoder.writeObject((Object)new Footer(footerMap));
        }
        return new EncodedMessage(messageFormat, buffer.getArray(), 0, buffer.getArrayLength());
    }

    private Section convertBody(PMQMessage message) throws JMSException {
        Data body = null;
        short orignalEncoding = 0;
        try {
            orignalEncoding = message.getShortProperty("JMS_AMQP_ORIGINAL_ENCODING");
        }
        catch (Exception exception) {
            // empty catch block
        }
        byte messageType = message.getDataStructureType();
        if (messageType == 23) {
            DataStructure data = message.getDataStructure();
            if (data instanceof ConnectionInfo) {
                ConnectionInfo connectionInfo = (ConnectionInfo)data;
                LinkedHashMap<String, Object> connectionMap = new LinkedHashMap<String, Object>();
                connectionMap.put("ConnectionId", connectionInfo.getConnectionId().getValue());
                connectionMap.put("ClientId", connectionInfo.getClientId());
                connectionMap.put("ClientIp", connectionInfo.getClientIp());
                connectionMap.put("UserName", connectionInfo.getUserName());
                connectionMap.put("BrokerMasterConnector", connectionInfo.isBrokerMasterConnector());
                connectionMap.put("Manageable", connectionInfo.isManageable());
                connectionMap.put("ClientMaster", connectionInfo.isClientMaster());
                connectionMap.put("FaultTolerant", connectionInfo.isFaultTolerant());
                connectionMap.put("FailoverReconnect", connectionInfo.isFailoverReconnect());
                body = new AmqpValue(connectionMap);
            } else if (data instanceof RemoveInfo) {
                RemoveInfo removeInfo = (RemoveInfo)message.getDataStructure();
                LinkedHashMap<String, Object> removeMap = new LinkedHashMap<String, Object>();
                if (removeInfo.isConnectionRemove()) {
                    removeMap.put(ConnectionId.class.getSimpleName(), ((ConnectionId)removeInfo.getObjectId()).getValue());
                } else if (removeInfo.isConsumerRemove()) {
                    removeMap.put(ConsumerId.class.getSimpleName(), ((ConsumerId)removeInfo.getObjectId()).getValue());
                    removeMap.put("SessionId", ((ConsumerId)removeInfo.getObjectId()).getSessionId());
                    removeMap.put("ConnectionId", ((ConsumerId)removeInfo.getObjectId()).getConnectionId());
                    removeMap.put("ParentId", ((ConsumerId)removeInfo.getObjectId()).getParentId());
                }
                body = new AmqpValue(removeMap);
            }
        } else if (messageType == 24) {
            Binary payload = AmqpMessageSupport.getBinaryFromMessageBody((PMQBytesMessage)message);
            if (payload == null) {
                payload = AmqpMessageSupport.EMPTY_BINARY;
            }
            switch (orignalEncoding) {
                case 1: {
                    break;
                }
                case 6: {
                    body = new AmqpValue((Object)payload);
                    break;
                }
                default: {
                    body = new Data(payload);
                    break;
                }
            }
        } else if (messageType == 28) {
            switch (orignalEncoding) {
                case 1: {
                    break;
                }
                case 2: {
                    body = new Data(AmqpMessageSupport.getBinaryFromMessageBody((PMQTextMessage)message));
                    break;
                }
                default: {
                    body = new AmqpValue((Object)((TextMessage)message).getText());
                    break;
                }
            }
        } else if (messageType == 25) {
            body = new AmqpValue(AmqpMessageSupport.getMapFromMessageBody((PMQMapMessage)message));
        } else if (messageType == 27) {
            ArrayList<Object> list = new ArrayList<Object>();
            PMQStreamMessage m = (PMQStreamMessage)message;
            try {
                while (true) {
                    list.add(m.readObject());
                }
            }
            catch (MessageEOFException messageEOFException) {
                switch (orignalEncoding) {
                    case 3: {
                        body = new AmqpSequence(list);
                        break;
                    }
                    default: {
                        body = new AmqpValue(list);
                        break;
                    }
                }
            }
        } else if (messageType == 26) {
            Binary payload = AmqpMessageSupport.getBinaryFromMessageBody((PMQObjectMessage)message);
            if (payload == null) {
                payload = AmqpMessageSupport.EMPTY_BINARY;
            }
            switch (orignalEncoding) {
                case 6: {
                    body = new AmqpValue((Object)payload);
                    break;
                }
                default: {
                    body = new Data(payload);
                }
            }
            if (!message.propertyExists("JMS_AMQP_ContentType")) {
                message.setReadOnlyProperties(false);
                message.setStringProperty("JMS_AMQP_ContentType", "application/x-java-serialized-object");
                message.setReadOnlyProperties(true);
            }
        }
        return body;
    }

    private static byte destinationType(PMQDestination destination) {
        if (destination.isQueue()) {
            if (destination.isTemporary()) {
                return 2;
            }
            return 0;
        }
        if (destination.isTopic()) {
            if (destination.isTemporary()) {
                return 3;
            }
            return 1;
        }
        throw new IllegalArgumentException("Unknown Destination Type passed to JMS Transformer.");
    }

    private static Object getOriginalMessageId(PMQMessage message) {
        Object result;
        MessageId messageId = message.getMessageId();
        if (messageId.getTextView() != null) {
            try {
                result = AMQPMessageIdHelper.INSTANCE.toIdObject(messageId.getTextView());
            }
            catch (AmqpProtocolException e) {
                result = messageId.getTextView();
            }
        } else {
            result = messageId.toString();
        }
        return result;
    }
}

