/*
 * Decompiled with CFR 0.152.
 */
package com.primeton.pmq.transport.amqp.protocol;

import com.primeton.pmq.command.Command;
import com.primeton.pmq.transport.amqp.ResponseHandler;
import com.primeton.pmq.transport.amqp.protocol.AmqpLink;
import com.primeton.pmq.transport.amqp.protocol.AmqpSession;
import java.util.ArrayList;
import java.util.List;
import org.apache.qpid.proton.amqp.transport.ErrorCondition;
import org.apache.qpid.proton.engine.Link;
import org.apache.qpid.proton.engine.Sender;

public abstract class AmqpAbstractLink<LINK_TYPE extends Link>
implements AmqpLink {
    protected final AmqpSession session;
    protected final LINK_TYPE endpoint;
    protected boolean closed;
    protected boolean opened;
    protected List<Runnable> closeActions = new ArrayList<Runnable>();

    public AmqpAbstractLink(AmqpSession session, LINK_TYPE endpoint) {
        this.session = session;
        this.endpoint = endpoint;
    }

    @Override
    public void open() {
        if (!this.opened) {
            this.getEndpoint().setContext((Object)this);
            this.getEndpoint().open();
            this.opened = true;
        }
    }

    @Override
    public void detach() {
        if (!this.closed && this.getEndpoint() != null) {
            this.getEndpoint().setContext(null);
            this.getEndpoint().detach();
            this.getEndpoint().free();
        }
    }

    @Override
    public void close(ErrorCondition error) {
        if (!this.closed) {
            if (this.getEndpoint() != null) {
                if (this.getEndpoint() instanceof Sender) {
                    this.getEndpoint().setSource(null);
                } else {
                    this.getEndpoint().setTarget(null);
                }
                this.getEndpoint().setCondition(error);
            }
            this.close();
        }
    }

    @Override
    public void close() {
        if (!this.closed) {
            if (this.getEndpoint() != null) {
                this.getEndpoint().setContext(null);
                this.getEndpoint().close();
                this.getEndpoint().free();
            }
            for (Runnable action : this.closeActions) {
                action.run();
            }
            this.closeActions.clear();
            this.opened = false;
            this.closed = true;
        }
    }

    public boolean isOpened() {
        return this.opened;
    }

    public boolean isClosed() {
        return this.closed;
    }

    public LINK_TYPE getEndpoint() {
        return this.endpoint;
    }

    public AmqpSession getSession() {
        return this.session;
    }

    @Override
    public void addCloseAction(Runnable action) {
        this.closeActions.add(action);
    }

    protected void sendToPMQ(Command command) {
        this.session.getConnection().sendToPMQ(command, null);
    }

    protected void sendToPMQ(Command command, ResponseHandler handler) {
        this.session.getConnection().sendToPMQ(command, handler);
    }
}

