/*
 * Decompiled with CFR 0.152.
 */
package com.primeton.pmq.transport.fanout;

import com.primeton.pmq.transport.MutexTransport;
import com.primeton.pmq.transport.ResponseCorrelator;
import com.primeton.pmq.transport.Transport;
import com.primeton.pmq.transport.TransportFactory;
import com.primeton.pmq.transport.TransportServer;
import com.primeton.pmq.transport.discovery.DiscoveryTransport;
import com.primeton.pmq.transport.discovery.DiscoveryTransportFactory;
import com.primeton.pmq.transport.fanout.FanoutTransport;
import com.primeton.pmq.util.IntrospectionSupport;
import com.primeton.pmq.util.URISupport;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;

public class FanoutTransportFactory
extends TransportFactory {
    @Override
    public Transport doConnect(URI location) throws IOException {
        try {
            Transport transport = this.createTransport(location);
            transport = new MutexTransport(transport);
            transport = new ResponseCorrelator(transport);
            return transport;
        }
        catch (URISyntaxException e) {
            throw new IOException("Invalid location: " + location);
        }
    }

    @Override
    public Transport doCompositeConnect(URI location) throws IOException {
        try {
            return this.createTransport(location);
        }
        catch (URISyntaxException e) {
            throw new IOException("Invalid location: " + location);
        }
    }

    public Transport createTransport(URI location) throws IOException, URISyntaxException {
        URISupport.CompositeData compositeData = URISupport.parseComposite(location);
        Map<String, String> parameters = compositeData.getParameters();
        FanoutTransport fanoutTransport = this.createTransport(parameters);
        DiscoveryTransport discoveryTransport = DiscoveryTransportFactory.createTransport(fanoutTransport, compositeData, parameters);
        return discoveryTransport;
    }

    public FanoutTransport createTransport(Map<String, String> parameters) throws IOException {
        FanoutTransport transport = new FanoutTransport();
        IntrospectionSupport.setProperties(transport, parameters);
        return transport;
    }

    @Override
    public TransportServer doBind(URI location) throws IOException {
        throw new IOException("Invalid server URI: " + location);
    }
}

