/*
 * Decompiled with CFR 0.152.
 */
package com.primeton.pmq.transport.http;

import com.primeton.pmq.transport.TransportSupport;
import com.primeton.pmq.util.ServiceStopper;
import com.primeton.pmq.wireformat.WireFormat;
import java.io.IOException;
import java.security.cert.X509Certificate;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;

public class BlockingQueueTransport
extends TransportSupport {
    public static final long MAX_TIMEOUT = 30000L;
    private BlockingQueue<Object> queue;

    public BlockingQueueTransport(BlockingQueue<Object> channel) {
        this.queue = channel;
    }

    public BlockingQueue<Object> getQueue() {
        return this.queue;
    }

    @Override
    public void oneway(Object command) throws IOException {
        try {
            boolean success = this.queue.offer(command, 30000L, TimeUnit.MILLISECONDS);
            if (!success) {
                throw new IOException("Fail to add to BlockingQueue. Add timed out after 30000ms: size=" + this.queue.size());
            }
        }
        catch (InterruptedException e) {
            throw new IOException("Fail to add to BlockingQueue. Interrupted while waiting for space: size=" + this.queue.size());
        }
    }

    @Override
    public String getRemoteAddress() {
        return "blockingQueue_" + this.queue.hashCode();
    }

    @Override
    protected void doStart() throws Exception {
    }

    @Override
    protected void doStop(ServiceStopper stopper) throws Exception {
    }

    @Override
    public int getReceiveCounter() {
        return 0;
    }

    @Override
    public X509Certificate[] getPeerCertificates() {
        return null;
    }

    @Override
    public void setPeerCertificates(X509Certificate[] certificates) {
    }

    @Override
    public WireFormat getWireFormat() {
        return null;
    }
}

