/*
 * Decompiled with CFR 0.152.
 */
package com.primeton.pmq.transport.mock;

import com.primeton.pmq.transport.MutexTransport;
import com.primeton.pmq.transport.ResponseCorrelator;
import com.primeton.pmq.transport.Transport;
import com.primeton.pmq.transport.TransportFactory;
import com.primeton.pmq.transport.TransportServer;
import com.primeton.pmq.transport.mock.MockTransport;
import com.primeton.pmq.util.IntrospectionSupport;
import com.primeton.pmq.util.URISupport;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;

public class MockTransportFactory
extends TransportFactory {
    @Override
    public Transport doConnect(URI location) throws URISyntaxException, Exception {
        Transport transport = this.createTransport(URISupport.parseComposite(location));
        transport = new MutexTransport(transport);
        transport = new ResponseCorrelator(transport);
        return transport;
    }

    @Override
    public Transport doCompositeConnect(URI location) throws URISyntaxException, Exception {
        return this.createTransport(URISupport.parseComposite(location));
    }

    public Transport createTransport(URISupport.CompositeData compositData) throws Exception {
        MockTransport transport = new MockTransport(TransportFactory.compositeConnect(compositData.getComponents()[0]));
        IntrospectionSupport.setProperties(transport, compositData.getParameters());
        return transport;
    }

    @Override
    public TransportServer doBind(URI location) throws IOException {
        throw new IOException("This protocol does not support being bound.");
    }
}

