/*
 * Decompiled with CFR 0.152.
 */
package com.primeton.pmq.transport.mqtt;

import com.primeton.pmq.broker.BrokerService;
import com.primeton.pmq.broker.BrokerServiceAware;
import com.primeton.pmq.transport.MutexTransport;
import com.primeton.pmq.transport.Transport;
import com.primeton.pmq.transport.mqtt.MQTTInactivityMonitor;
import com.primeton.pmq.transport.mqtt.MQTTNIOTransport;
import com.primeton.pmq.transport.mqtt.MQTTTransportFilter;
import com.primeton.pmq.transport.nio.NIOTransportFactory;
import com.primeton.pmq.transport.tcp.TcpTransport;
import com.primeton.pmq.transport.tcp.TcpTransportServer;
import com.primeton.pmq.util.IntrospectionSupport;
import com.primeton.pmq.wireformat.WireFormat;
import java.io.IOException;
import java.net.Socket;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Map;
import javax.net.ServerSocketFactory;
import javax.net.SocketFactory;

public class MQTTNIOTransportFactory
extends NIOTransportFactory
implements BrokerServiceAware {
    private BrokerService brokerService = null;

    @Override
    protected String getDefaultWireFormatType() {
        return "mqtt";
    }

    @Override
    protected TcpTransportServer createTcpTransportServer(URI location, ServerSocketFactory serverSocketFactory) throws IOException, URISyntaxException {
        TcpTransportServer result = new TcpTransportServer(this, location, serverSocketFactory){

            @Override
            protected Transport createTransport(Socket socket, WireFormat format2) throws IOException {
                return new MQTTNIOTransport(format2, socket);
            }
        };
        result.setAllowLinkStealing(true);
        return result;
    }

    @Override
    protected TcpTransport createTcpTransport(WireFormat wf, SocketFactory socketFactory, URI location, URI localLocation) throws UnknownHostException, IOException {
        return new MQTTNIOTransport(wf, socketFactory, location, localLocation);
    }

    @Override
    public TcpTransport createTransport(WireFormat wireFormat, Socket socket, TcpTransport.InitBuffer initBuffer) throws IOException {
        return new MQTTNIOTransport(wireFormat, socket, initBuffer);
    }

    @Override
    public Transport serverConfigure(Transport transport, WireFormat format2, HashMap options) throws Exception {
        MutexTransport mutex = (transport = super.serverConfigure(transport, format2, options)).narrow(MutexTransport.class);
        if (mutex != null) {
            mutex.setSyncOnCommand(true);
        }
        return transport;
    }

    @Override
    public Transport compositeConfigure(Transport transport, WireFormat format2, Map options) {
        transport = new MQTTTransportFilter(transport, format2, this.brokerService);
        IntrospectionSupport.setProperties(transport, options);
        return super.compositeConfigure(transport, format2, options);
    }

    @Override
    public void setBrokerService(BrokerService brokerService) {
        this.brokerService = brokerService;
    }

    @Override
    protected Transport createInactivityMonitor(Transport transport, WireFormat format2) {
        MQTTInactivityMonitor monitor = new MQTTInactivityMonitor(transport, format2);
        MQTTTransportFilter filter = transport.narrow(MQTTTransportFilter.class);
        filter.setInactivityMonitor(monitor);
        return monitor;
    }
}

