/*
 * Decompiled with CFR 0.152.
 */
package com.primeton.pmq.transport.mqtt;

import com.primeton.pmq.broker.BrokerService;
import com.primeton.pmq.broker.BrokerServiceAware;
import com.primeton.pmq.transport.MutexTransport;
import com.primeton.pmq.transport.Transport;
import com.primeton.pmq.transport.mqtt.MQTTInactivityMonitor;
import com.primeton.pmq.transport.mqtt.MQTTTransportFilter;
import com.primeton.pmq.transport.tcp.SslTransportFactory;
import com.primeton.pmq.transport.tcp.SslTransportServer;
import com.primeton.pmq.util.IntrospectionSupport;
import com.primeton.pmq.wireformat.WireFormat;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import javax.net.ssl.SSLServerSocketFactory;

public class MQTTSslTransportFactory
extends SslTransportFactory
implements BrokerServiceAware {
    private BrokerService brokerService = null;

    @Override
    protected String getDefaultWireFormatType() {
        return "mqtt";
    }

    @Override
    public Transport compositeConfigure(Transport transport, WireFormat format2, Map options) {
        transport = new MQTTTransportFilter(transport, format2, this.brokerService);
        IntrospectionSupport.setProperties(transport, options);
        return super.compositeConfigure(transport, format2, options);
    }

    @Override
    protected SslTransportServer createSslTransportServer(URI location, SSLServerSocketFactory serverSocketFactory) throws IOException, URISyntaxException {
        SslTransportServer server = super.createSslTransportServer(location, serverSocketFactory);
        server.setAllowLinkStealing(true);
        return server;
    }

    @Override
    public Transport serverConfigure(Transport transport, WireFormat format2, HashMap options) throws Exception {
        MutexTransport mutex = (transport = super.serverConfigure(transport, format2, options)).narrow(MutexTransport.class);
        if (mutex != null) {
            mutex.setSyncOnCommand(true);
        }
        return transport;
    }

    @Override
    public void setBrokerService(BrokerService brokerService) {
        this.brokerService = brokerService;
    }

    @Override
    protected Transport createInactivityMonitor(Transport transport, WireFormat format2) {
        MQTTInactivityMonitor monitor = new MQTTInactivityMonitor(transport, format2);
        MQTTTransportFilter filter = transport.narrow(MQTTTransportFilter.class);
        filter.setInactivityMonitor(monitor);
        return monitor;
    }
}

