/*
 * Decompiled with CFR 0.152.
 */
package com.primeton.pmq.transport.multicast;

import com.primeton.pmq.command.Command;
import com.primeton.pmq.command.Endpoint;
import com.primeton.pmq.transport.udp.DatagramEndpoint;
import com.primeton.pmq.transport.udp.DatagramHeaderMarshaller;
import java.net.SocketAddress;
import java.nio.ByteBuffer;

public class MulticastDatagramHeaderMarshaller
extends DatagramHeaderMarshaller {
    private final byte[] localUriAsBytes;

    public MulticastDatagramHeaderMarshaller(String localUri) {
        this.localUriAsBytes = localUri.getBytes();
    }

    @Override
    public Endpoint createEndpoint(ByteBuffer readBuffer, SocketAddress address) {
        int size2 = readBuffer.getInt();
        byte[] data = new byte[size2];
        readBuffer.get(data);
        return new DatagramEndpoint(new String(data), address);
    }

    @Override
    public void writeHeader(Command command, ByteBuffer writeBuffer) {
        writeBuffer.putInt(this.localUriAsBytes.length);
        writeBuffer.put(this.localUriAsBytes);
        super.writeHeader(command, writeBuffer);
    }
}

