/*
 * Decompiled with CFR 0.152.
 */
package com.primeton.pmq.transport.stomp;

import com.primeton.pmq.broker.SslContext;
import com.primeton.pmq.transport.Transport;
import com.primeton.pmq.transport.TransportServer;
import com.primeton.pmq.transport.nio.NIOSSLTransportServer;
import com.primeton.pmq.transport.stomp.StompNIOSSLTransport;
import com.primeton.pmq.transport.stomp.StompNIOTransportFactory;
import com.primeton.pmq.transport.tcp.TcpTransport;
import com.primeton.pmq.transport.tcp.TcpTransportServer;
import com.primeton.pmq.wireformat.WireFormat;
import java.io.IOException;
import java.net.Socket;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import javax.net.ServerSocketFactory;
import javax.net.SocketFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;

public class StompNIOSSLTransportFactory
extends StompNIOTransportFactory {
    protected SSLContext context;

    @Override
    protected TcpTransportServer createTcpTransportServer(URI location, ServerSocketFactory serverSocketFactory) throws IOException, URISyntaxException {
        return new NIOSSLTransportServer(this.context, this, location, serverSocketFactory){

            @Override
            protected Transport createTransport(Socket socket, WireFormat format2) throws IOException {
                StompNIOSSLTransport transport = new StompNIOSSLTransport(format2, socket);
                if (StompNIOSSLTransportFactory.this.context != null) {
                    transport.setSslContext(StompNIOSSLTransportFactory.this.context);
                }
                transport.setNeedClientAuth(this.isNeedClientAuth());
                transport.setWantClientAuth(this.isWantClientAuth());
                return transport;
            }
        };
    }

    @Override
    protected TcpTransport createTcpTransport(WireFormat wf, SocketFactory socketFactory, URI location, URI localLocation) throws UnknownHostException, IOException {
        return new StompNIOSSLTransport(wf, socketFactory, location, localLocation);
    }

    @Override
    public TcpTransport createTransport(WireFormat wireFormat, Socket socket, SSLEngine engine, TcpTransport.InitBuffer initBuffer, ByteBuffer inputBuffer) throws IOException {
        return new StompNIOSSLTransport(wireFormat, socket, engine, initBuffer, inputBuffer);
    }

    @Override
    public TransportServer doBind(URI location) throws IOException {
        if (SslContext.getCurrentSslContext() != null) {
            try {
                this.context = SslContext.getCurrentSslContext().getSSLContext();
            }
            catch (Exception e) {
                throw new IOException(e);
            }
        }
        return super.doBind(location);
    }
}

