/*
 * Decompiled with CFR 0.152.
 */
package com.primeton.pmq.transport.stomp;

import com.primeton.pmq.broker.BrokerContext;
import com.primeton.pmq.broker.BrokerService;
import com.primeton.pmq.broker.BrokerServiceAware;
import com.primeton.pmq.transport.MutexTransport;
import com.primeton.pmq.transport.Transport;
import com.primeton.pmq.transport.nio.NIOTransportFactory;
import com.primeton.pmq.transport.stomp.StompInactivityMonitor;
import com.primeton.pmq.transport.stomp.StompNIOTransport;
import com.primeton.pmq.transport.stomp.StompTransportFilter;
import com.primeton.pmq.transport.tcp.TcpTransport;
import com.primeton.pmq.transport.tcp.TcpTransportServer;
import com.primeton.pmq.util.IntrospectionSupport;
import com.primeton.pmq.wireformat.WireFormat;
import java.io.IOException;
import java.net.Socket;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Map;
import javax.net.ServerSocketFactory;
import javax.net.SocketFactory;

public class StompNIOTransportFactory
extends NIOTransportFactory
implements BrokerServiceAware {
    private BrokerContext brokerContext = null;

    @Override
    protected String getDefaultWireFormatType() {
        return "stomp";
    }

    @Override
    protected TcpTransportServer createTcpTransportServer(URI location, ServerSocketFactory serverSocketFactory) throws IOException, URISyntaxException {
        return new TcpTransportServer(this, location, serverSocketFactory){

            @Override
            protected Transport createTransport(Socket socket, WireFormat format2) throws IOException {
                return new StompNIOTransport(format2, socket);
            }
        };
    }

    @Override
    protected TcpTransport createTcpTransport(WireFormat wf, SocketFactory socketFactory, URI location, URI localLocation) throws UnknownHostException, IOException {
        return new StompNIOTransport(wf, socketFactory, location, localLocation);
    }

    @Override
    public TcpTransport createTransport(WireFormat wireFormat, Socket socket, TcpTransport.InitBuffer initBuffer) throws IOException {
        return new StompNIOTransport(wireFormat, socket, initBuffer);
    }

    @Override
    public Transport serverConfigure(Transport transport, WireFormat format2, HashMap options) throws Exception {
        MutexTransport mutex = (transport = super.serverConfigure(transport, format2, options)).narrow(MutexTransport.class);
        if (mutex != null) {
            mutex.setSyncOnCommand(true);
        }
        return transport;
    }

    @Override
    public Transport compositeConfigure(Transport transport, WireFormat format2, Map options) {
        transport = new StompTransportFilter(transport, format2, this.brokerContext);
        IntrospectionSupport.setProperties(transport, options);
        return super.compositeConfigure(transport, format2, options);
    }

    @Override
    public void setBrokerService(BrokerService brokerService) {
        this.brokerContext = brokerService.getBrokerContext();
    }

    @Override
    protected Transport createInactivityMonitor(Transport transport, WireFormat format2) {
        StompInactivityMonitor monitor = new StompInactivityMonitor(transport, format2);
        StompTransportFilter filter = transport.narrow(StompTransportFilter.class);
        filter.setInactivityMonitor(monitor);
        return monitor;
    }
}

