/*
 * Decompiled with CFR 0.152.
 */
package com.primeton.pmq.transport.stomp;

import com.primeton.pmq.broker.BrokerContext;
import com.primeton.pmq.command.Command;
import com.primeton.pmq.transport.Transport;
import com.primeton.pmq.transport.TransportFilter;
import com.primeton.pmq.transport.TransportListener;
import com.primeton.pmq.transport.stomp.ProtocolConverter;
import com.primeton.pmq.transport.stomp.StompFrame;
import com.primeton.pmq.transport.stomp.StompInactivityMonitor;
import com.primeton.pmq.transport.stomp.StompTransport;
import com.primeton.pmq.transport.stomp.StompWireFormat;
import com.primeton.pmq.util.IOExceptionSupport;
import com.primeton.pmq.wireformat.WireFormat;
import java.io.IOException;
import javax.jms.JMSException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StompTransportFilter
extends TransportFilter
implements StompTransport {
    private static final Logger TRACE = LoggerFactory.getLogger((String)(StompTransportFilter.class.getPackage().getName() + ".StompIO"));
    private final ProtocolConverter protocolConverter;
    private StompInactivityMonitor monitor;
    private StompWireFormat wireFormat;
    private boolean trace;

    public StompTransportFilter(Transport next, WireFormat wireFormat, BrokerContext brokerContext) {
        super(next);
        this.protocolConverter = new ProtocolConverter(this, brokerContext);
        if (wireFormat instanceof StompWireFormat) {
            this.wireFormat = (StompWireFormat)wireFormat;
        }
    }

    @Override
    public void start() throws Exception {
        if (this.monitor != null) {
            this.monitor.startConnectCheckTask(this.getConnectAttemptTimeout());
        }
        super.start();
    }

    @Override
    public void oneway(Object o) throws IOException {
        try {
            Command command = (Command)o;
            this.protocolConverter.onPMQCommand(command);
        }
        catch (JMSException e) {
            throw IOExceptionSupport.create((Exception)((Object)e));
        }
    }

    @Override
    public void onCommand(Object command) {
        try {
            if (this.trace) {
                TRACE.trace("Received: \n" + command);
            }
            this.protocolConverter.onStompCommand((StompFrame)command);
        }
        catch (IOException e) {
            this.onException(e);
        }
        catch (JMSException e) {
            this.onException(IOExceptionSupport.create((Exception)((Object)e)));
        }
    }

    @Override
    public void sendToPMQ(Command command) {
        TransportListener l = this.transportListener;
        if (l != null) {
            l.onCommand(command);
        }
    }

    @Override
    public void sendToStomp(StompFrame command) throws IOException {
        Transport n;
        if (this.trace) {
            TRACE.trace("Sending: \n" + command);
        }
        if ((n = this.next) != null) {
            n.oneway(command);
        }
    }

    public boolean isTrace() {
        return this.trace;
    }

    public void setTrace(boolean trace) {
        this.trace = trace;
    }

    @Override
    public StompInactivityMonitor getInactivityMonitor() {
        return this.monitor;
    }

    public void setInactivityMonitor(StompInactivityMonitor monitor) {
        this.monitor = monitor;
    }

    @Override
    public StompWireFormat getWireFormat() {
        return this.wireFormat;
    }

    public String getDefaultHeartBeat() {
        return this.protocolConverter != null ? this.protocolConverter.getDefaultHeartBeat() : null;
    }

    public void setDefaultHeartBeat(String defaultHeartBeat) {
        this.protocolConverter.setDefaultHeartBeat(defaultHeartBeat);
    }

    public float getHbGracePeriodMultiplier() {
        return (this.protocolConverter != null ? Float.valueOf(this.protocolConverter.getHbGracePeriodMultiplier()) : null).floatValue();
    }

    public void setHbGracePeriodMultiplier(float hbGracePeriodMultiplier) {
        if (hbGracePeriodMultiplier > 1.0f) {
            this.protocolConverter.setHbGracePeriodMultiplier(hbGracePeriodMultiplier);
        }
    }

    public void setMaxDataLength(int maxDataLength) {
        this.wireFormat.setMaxDataLength(maxDataLength);
    }

    public int getMaxDataLength() {
        return this.wireFormat.getMaxDataLength();
    }

    public void setMaxFrameSize(int maxFrameSize) {
        this.wireFormat.setMaxFrameSize(maxFrameSize);
    }

    public long getMaxFrameSize() {
        return this.wireFormat.getMaxFrameSize();
    }

    public long getConnectAttemptTimeout() {
        return this.wireFormat.getConnectionAttemptTimeout();
    }

    public void setConnectAttemptTimeout(long timeout) {
        this.wireFormat.setConnectionAttemptTimeout(timeout);
    }
}

