/*
 * Decompiled with CFR 0.152.
 */
package com.primeton.pmq.transport.ws;

import com.primeton.pmq.broker.BrokerService;
import com.primeton.pmq.broker.BrokerServiceAware;
import com.primeton.pmq.command.Command;
import com.primeton.pmq.jms.pool.IntrospectionSupport;
import com.primeton.pmq.transport.TransportSupport;
import com.primeton.pmq.transport.mqtt.MQTTInactivityMonitor;
import com.primeton.pmq.transport.mqtt.MQTTProtocolConverter;
import com.primeton.pmq.transport.mqtt.MQTTTransport;
import com.primeton.pmq.transport.mqtt.MQTTWireFormat;
import com.primeton.pmq.util.IOExceptionSupport;
import com.primeton.pmq.util.ServiceStopper;
import java.io.IOException;
import java.security.cert.X509Certificate;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.locks.ReentrantLock;
import org.fusesource.mqtt.codec.MQTTFrame;

public abstract class AbstractMQTTSocket
extends TransportSupport
implements MQTTTransport,
BrokerServiceAware {
    protected ReentrantLock protocolLock = new ReentrantLock();
    protected volatile MQTTProtocolConverter protocolConverter = null;
    protected MQTTWireFormat wireFormat = new MQTTWireFormat();
    protected final MQTTInactivityMonitor mqttInactivityMonitor = new MQTTInactivityMonitor(this, this.wireFormat);
    protected final CountDownLatch socketTransportStarted = new CountDownLatch(1);
    protected BrokerService brokerService;
    protected volatile int receiveCounter;
    protected final String remoteAddress;
    protected X509Certificate[] peerCertificates;
    private Map<String, Object> transportOptions;

    public AbstractMQTTSocket(String remoteAddress) {
        this.remoteAddress = remoteAddress;
    }

    @Override
    public void oneway(Object command) throws IOException {
        this.protocolLock.lock();
        try {
            this.getProtocolConverter().onPMQCommand((Command)command);
        }
        catch (Exception e) {
            this.onException(IOExceptionSupport.create(e));
        }
        finally {
            this.protocolLock.unlock();
        }
    }

    @Override
    public void sendToPMQ(Command command) {
        this.protocolLock.lock();
        try {
            this.doConsume(command);
        }
        finally {
            this.protocolLock.unlock();
        }
    }

    @Override
    protected void doStop(ServiceStopper stopper) throws Exception {
        this.mqttInactivityMonitor.stop();
        this.handleStopped();
    }

    @Override
    protected void doStart() throws Exception {
        this.socketTransportStarted.countDown();
        this.mqttInactivityMonitor.setTransportListener(this.getTransportListener());
        this.mqttInactivityMonitor.startConnectChecker(this.wireFormat.getConnectAttemptTimeout());
    }

    @Override
    public abstract void sendToMQTT(MQTTFrame var1) throws IOException;

    public abstract void handleStopped() throws IOException;

    @Override
    public MQTTInactivityMonitor getInactivityMonitor() {
        return this.mqttInactivityMonitor;
    }

    @Override
    public MQTTWireFormat getWireFormat() {
        return this.wireFormat;
    }

    @Override
    public String getRemoteAddress() {
        return this.remoteAddress;
    }

    @Override
    public int getReceiveCounter() {
        return this.receiveCounter;
    }

    @Override
    public X509Certificate[] getPeerCertificates() {
        return this.peerCertificates;
    }

    @Override
    public void setPeerCertificates(X509Certificate[] certificates) {
        this.peerCertificates = certificates;
    }

    @Override
    public void setBrokerService(BrokerService brokerService) {
        this.brokerService = brokerService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected MQTTProtocolConverter getProtocolConverter() {
        if (this.protocolConverter == null) {
            AbstractMQTTSocket abstractMQTTSocket = this;
            synchronized (abstractMQTTSocket) {
                if (this.protocolConverter == null) {
                    this.protocolConverter = new MQTTProtocolConverter(this, this.brokerService);
                    IntrospectionSupport.setProperties(this.protocolConverter, this.transportOptions);
                }
            }
        }
        return this.protocolConverter;
    }

    protected boolean transportStartedAtLeastOnce() {
        return this.socketTransportStarted.getCount() == 0L;
    }

    public void setTransportOptions(Map<String, Object> transportOptions) {
        this.transportOptions = transportOptions;
    }
}

