/*
 * Decompiled with CFR 0.152.
 */
package com.primeton.pmq.transport.ws;

import com.primeton.pmq.command.Command;
import com.primeton.pmq.command.KeepAliveInfo;
import com.primeton.pmq.transport.TransportSupport;
import com.primeton.pmq.transport.stomp.ProtocolConverter;
import com.primeton.pmq.transport.stomp.StompFrame;
import com.primeton.pmq.transport.stomp.StompInactivityMonitor;
import com.primeton.pmq.transport.stomp.StompTransport;
import com.primeton.pmq.transport.stomp.StompWireFormat;
import com.primeton.pmq.util.ByteSequence;
import com.primeton.pmq.util.IOExceptionSupport;
import com.primeton.pmq.util.ServiceStopper;
import java.io.IOException;
import java.security.cert.X509Certificate;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.locks.ReentrantLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractStompSocket
extends TransportSupport
implements StompTransport {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractStompSocket.class);
    protected ReentrantLock protocolLock = new ReentrantLock();
    protected ProtocolConverter protocolConverter = new ProtocolConverter(this, null);
    protected StompWireFormat wireFormat = new StompWireFormat();
    protected final CountDownLatch socketTransportStarted = new CountDownLatch(1);
    protected final StompInactivityMonitor stompInactivityMonitor = new StompInactivityMonitor(this, this.wireFormat);
    protected volatile int receiveCounter;
    protected final String remoteAddress;
    protected X509Certificate[] certificates;

    public AbstractStompSocket(String remoteAddress) {
        this.remoteAddress = remoteAddress;
    }

    @Override
    public void oneway(Object command) throws IOException {
        this.protocolLock.lock();
        try {
            this.protocolConverter.onPMQCommand((Command)command);
        }
        catch (Exception e) {
            this.onException(IOExceptionSupport.create(e));
        }
        finally {
            this.protocolLock.unlock();
        }
    }

    @Override
    public void sendToPMQ(Command command) {
        this.protocolLock.lock();
        try {
            this.doConsume(command);
        }
        finally {
            this.protocolLock.unlock();
        }
    }

    @Override
    protected void doStop(ServiceStopper stopper) throws Exception {
        this.stompInactivityMonitor.stop();
        this.handleStopped();
    }

    @Override
    protected void doStart() throws Exception {
        this.socketTransportStarted.countDown();
        this.stompInactivityMonitor.setTransportListener(this.getTransportListener());
        this.stompInactivityMonitor.startConnectCheckTask();
    }

    @Override
    public abstract void sendToStomp(StompFrame var1) throws IOException;

    public abstract void handleStopped() throws IOException;

    @Override
    public StompInactivityMonitor getInactivityMonitor() {
        return this.stompInactivityMonitor;
    }

    @Override
    public StompWireFormat getWireFormat() {
        return this.wireFormat;
    }

    @Override
    public String getRemoteAddress() {
        return this.remoteAddress;
    }

    @Override
    public int getReceiveCounter() {
        return this.receiveCounter;
    }

    protected void processStompFrame(String data) {
        if (!this.transportStartedAtLeastOnce()) {
            LOG.debug("Waiting for StompSocket to be properly started...");
            try {
                this.socketTransportStarted.await();
            }
            catch (InterruptedException e) {
                LOG.warn("While waiting for StompSocket to be properly started, we got interrupted!! Should be okay, but you could see race conditions...");
            }
        }
        this.protocolLock.lock();
        try {
            if (data != null) {
                this.receiveCounter += data.length();
                if (data.equals("\n")) {
                    this.stompInactivityMonitor.onCommand(new KeepAliveInfo());
                } else {
                    StompFrame frame = (StompFrame)this.wireFormat.unmarshal(new ByteSequence(data.getBytes("UTF-8")));
                    frame.setTransportContext(this.getPeerCertificates());
                    this.protocolConverter.onStompCommand(frame);
                }
            }
        }
        catch (Exception e) {
            this.onException(IOExceptionSupport.create(e));
        }
        finally {
            this.protocolLock.unlock();
        }
    }

    private boolean transportStartedAtLeastOnce() {
        return this.socketTransportStarted.getCount() == 0L;
    }

    @Override
    public X509Certificate[] getPeerCertificates() {
        return this.certificates;
    }

    @Override
    public void setPeerCertificates(X509Certificate[] certificates) {
        this.certificates = certificates;
    }
}

