/*
 * Decompiled with CFR 0.152.
 */
package com.primeton.pmq;

import com.primeton.pmq.PMQDispatcher;
import com.primeton.pmq.PMQMessageAudit;
import com.primeton.pmq.command.Message;
import com.primeton.pmq.command.PMQDestination;
import com.primeton.pmq.util.LRUCache;
import java.util.LinkedHashMap;

class ConnectionAudit {
    private boolean checkForDuplicates;
    private LinkedHashMap<PMQDestination, PMQMessageAudit> destinations = new LRUCache<PMQDestination, PMQMessageAudit>(1000);
    private LinkedHashMap<PMQDispatcher, PMQMessageAudit> dispatchers = new LRUCache<PMQDispatcher, PMQMessageAudit>(1000);
    private int auditDepth = 2048;
    private int auditMaximumProducerNumber = 64;

    ConnectionAudit() {
    }

    synchronized void removeDispatcher(PMQDispatcher dispatcher) {
        this.dispatchers.remove(dispatcher);
    }

    synchronized boolean isDuplicate(PMQDispatcher dispatcher, Message message) {
        PMQDestination destination;
        if (this.checkForDuplicates && message != null && (destination = message.getDestination()) != null) {
            if (destination.isQueue()) {
                PMQMessageAudit audit = this.destinations.get(destination);
                if (audit == null) {
                    audit = new PMQMessageAudit(this.auditDepth, this.auditMaximumProducerNumber);
                    this.destinations.put(destination, audit);
                }
                boolean result = audit.isDuplicate(message);
                return result;
            }
            PMQMessageAudit audit = this.dispatchers.get(dispatcher);
            if (audit == null) {
                audit = new PMQMessageAudit(this.auditDepth, this.auditMaximumProducerNumber);
                this.dispatchers.put(dispatcher, audit);
            }
            boolean result = audit.isDuplicate(message);
            return result;
        }
        return false;
    }

    protected synchronized void rollbackDuplicate(PMQDispatcher dispatcher, Message message) {
        PMQDestination destination;
        if (this.checkForDuplicates && message != null && (destination = message.getDestination()) != null) {
            if (destination.isQueue()) {
                PMQMessageAudit audit = this.destinations.get(destination);
                if (audit != null) {
                    audit.rollback(message);
                }
            } else {
                PMQMessageAudit audit = this.dispatchers.get(dispatcher);
                if (audit != null) {
                    audit.rollback(message);
                }
            }
        }
    }

    boolean isCheckForDuplicates() {
        return this.checkForDuplicates;
    }

    void setCheckForDuplicates(boolean checkForDuplicates) {
        this.checkForDuplicates = checkForDuplicates;
    }

    public int getAuditDepth() {
        return this.auditDepth;
    }

    public void setAuditDepth(int auditDepth) {
        this.auditDepth = auditDepth;
    }

    public int getAuditMaximumProducerNumber() {
        return this.auditMaximumProducerNumber;
    }

    public void setAuditMaximumProducerNumber(int auditMaximumProducerNumber) {
        this.auditMaximumProducerNumber = auditMaximumProducerNumber;
    }
}

