/*
 * Decompiled with CFR 0.152.
 */
package com.primeton.pmq;

import com.primeton.pmq.BlobMessage;
import com.primeton.pmq.PMQConnection;
import com.primeton.pmq.blob.BlobDownloader;
import com.primeton.pmq.command.PMQBlobMessage;
import com.primeton.pmq.command.PMQBytesMessage;
import com.primeton.pmq.command.PMQDestination;
import com.primeton.pmq.command.PMQMapMessage;
import com.primeton.pmq.command.PMQMessage;
import com.primeton.pmq.command.PMQObjectMessage;
import com.primeton.pmq.command.PMQStreamMessage;
import com.primeton.pmq.command.PMQTextMessage;
import java.net.MalformedURLException;
import java.util.Enumeration;
import javax.jms.BytesMessage;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.MessageEOFException;
import javax.jms.ObjectMessage;
import javax.jms.StreamMessage;
import javax.jms.TextMessage;

public final class PMQMessageTransformation {
    private PMQMessageTransformation() {
    }

    public static PMQDestination transformDestination(Destination destination) throws JMSException {
        return PMQDestination.transform(destination);
    }

    public static PMQMessage transformMessage(Message message, PMQConnection connection) throws JMSException {
        if (message instanceof PMQMessage) {
            return (PMQMessage)message;
        }
        PMQMessage activeMessage = null;
        if (message instanceof BytesMessage) {
            BytesMessage bytesMsg = (BytesMessage)message;
            bytesMsg.reset();
            PMQBytesMessage msg = new PMQBytesMessage();
            msg.setConnection(connection);
            try {
                while (true) {
                    msg.writeByte(bytesMsg.readByte());
                }
            }
            catch (MessageEOFException messageEOFException) {
            }
            catch (JMSException jMSException) {
                // empty catch block
            }
            activeMessage = msg;
        } else if (message instanceof MapMessage) {
            MapMessage mapMsg = (MapMessage)message;
            PMQMapMessage msg = new PMQMapMessage();
            msg.setConnection(connection);
            Enumeration iter = mapMsg.getMapNames();
            while (iter.hasMoreElements()) {
                String name = iter.nextElement().toString();
                msg.setObject(name, mapMsg.getObject(name));
            }
            activeMessage = msg;
        } else if (message instanceof ObjectMessage) {
            ObjectMessage objMsg = (ObjectMessage)message;
            PMQObjectMessage msg = new PMQObjectMessage();
            msg.setConnection(connection);
            msg.setObject(objMsg.getObject());
            msg.storeContent();
            activeMessage = msg;
        } else if (message instanceof StreamMessage) {
            StreamMessage streamMessage = (StreamMessage)message;
            streamMessage.reset();
            PMQStreamMessage msg = new PMQStreamMessage();
            msg.setConnection(connection);
            Object obj = null;
            try {
                while ((obj = streamMessage.readObject()) != null) {
                    msg.writeObject(obj);
                }
            }
            catch (MessageEOFException messageEOFException) {
            }
            catch (JMSException jMSException) {
                // empty catch block
            }
            activeMessage = msg;
        } else if (message instanceof TextMessage) {
            TextMessage textMsg = (TextMessage)message;
            PMQTextMessage msg = new PMQTextMessage();
            msg.setConnection(connection);
            msg.setText(textMsg.getText());
            activeMessage = msg;
        } else if (message instanceof BlobMessage) {
            BlobMessage blobMessage = (BlobMessage)message;
            PMQBlobMessage msg = new PMQBlobMessage();
            msg.setConnection(connection);
            if (connection != null) {
                msg.setBlobDownloader(new BlobDownloader(connection.getBlobTransferPolicy()));
            }
            try {
                msg.setURL(blobMessage.getURL());
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
            activeMessage = msg;
        } else {
            activeMessage = new PMQMessage();
            activeMessage.setConnection(connection);
        }
        PMQMessageTransformation.copyProperties(message, activeMessage);
        return activeMessage;
    }

    public static void copyProperties(Message fromMessage, Message toMessage) throws JMSException {
        toMessage.setJMSMessageID(fromMessage.getJMSMessageID());
        toMessage.setJMSCorrelationID(fromMessage.getJMSCorrelationID());
        toMessage.setJMSReplyTo((Destination)PMQMessageTransformation.transformDestination(fromMessage.getJMSReplyTo()));
        toMessage.setJMSDestination((Destination)PMQMessageTransformation.transformDestination(fromMessage.getJMSDestination()));
        toMessage.setJMSDeliveryMode(fromMessage.getJMSDeliveryMode());
        toMessage.setJMSRedelivered(fromMessage.getJMSRedelivered());
        toMessage.setJMSType(fromMessage.getJMSType());
        toMessage.setJMSExpiration(fromMessage.getJMSExpiration());
        toMessage.setJMSPriority(fromMessage.getJMSPriority());
        toMessage.setJMSTimestamp(fromMessage.getJMSTimestamp());
        Enumeration propertyNames = fromMessage.getPropertyNames();
        while (propertyNames.hasMoreElements()) {
            String name = propertyNames.nextElement().toString();
            Object obj = fromMessage.getObjectProperty(name);
            toMessage.setObjectProperty(name, obj);
        }
    }
}

