/*
 * Decompiled with CFR 0.152.
 */
package com.primeton.pmq;

import com.primeton.pmq.PMQQueueSession;
import com.primeton.pmq.PMQSession;
import com.primeton.pmq.PMQTopicSession;
import com.primeton.pmq.PMQXAConnection;
import com.primeton.pmq.command.SessionId;
import javax.jms.JMSException;
import javax.jms.QueueSession;
import javax.jms.Session;
import javax.jms.TopicSession;
import javax.jms.TransactionInProgressException;
import javax.jms.XAQueueSession;
import javax.jms.XATopicSession;
import javax.transaction.xa.XAResource;

public class PMQXASession
extends PMQSession
implements QueueSession,
TopicSession,
XAQueueSession,
XATopicSession {
    public PMQXASession(PMQXAConnection connection, SessionId sessionId, int theAcknowlegeMode, boolean dispatchAsync) throws JMSException {
        super(connection, sessionId, theAcknowlegeMode, dispatchAsync);
    }

    @Override
    public boolean getTransacted() throws JMSException {
        this.checkClosed();
        return this.getTransactionContext().isInXATransaction();
    }

    @Override
    public void rollback() throws JMSException {
        this.checkClosed();
        throw new TransactionInProgressException("Cannot rollback() inside an XASession");
    }

    @Override
    public void commit() throws JMSException {
        this.checkClosed();
        throw new TransactionInProgressException("Cannot commit() inside an XASession");
    }

    public Session getSession() throws JMSException {
        return this;
    }

    public XAResource getXAResource() {
        return this.getTransactionContext();
    }

    public QueueSession getQueueSession() throws JMSException {
        return new PMQQueueSession(this);
    }

    public TopicSession getTopicSession() throws JMSException {
        return new PMQTopicSession(this);
    }

    @Override
    public boolean isAutoAcknowledge() {
        return true;
    }

    @Override
    protected void doStartTransaction() throws JMSException {
    }
}

