/*
 * Decompiled with CFR 0.152.
 */
package com.primeton.pmq;

import com.primeton.pmq.sm2.SM2;
import com.primeton.pmq.sm2.SM2KeyPair;
import com.primeton.pmq.sm3.SM3;
import com.primeton.pmq.sm4.SM4;
import com.primeton.pmq.sm4.SM4_Context;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.bouncycastle.util.encoders.Base64;
import sun.misc.BASE64Decoder;
import sun.misc.BASE64Encoder;

public class SMUtil {
    public static final String IV = "UISwD9fW6cFh9SNS";

    private static String encryptData_ECB(String plainText, boolean hexString, String secretKey) {
        try {
            SM4_Context ctx = new SM4_Context();
            ctx.isPadding = true;
            ctx.mode = 1;
            byte[] keyBytes = hexString ? SMUtil.hexStringToBytes(secretKey) : secretKey.getBytes();
            SM4 sm4 = new SM4();
            sm4.sm4_setkey_enc(ctx, keyBytes);
            byte[] encrypted = sm4.sm4_crypt_ecb(ctx, plainText.getBytes("UTF-8"));
            String cipherText = new BASE64Encoder().encode(encrypted);
            if (cipherText != null && cipherText.trim().length() > 0) {
                Pattern p = Pattern.compile("\\s*|\t|\r|\n");
                Matcher m = p.matcher(cipherText);
                cipherText = m.replaceAll("");
            }
            return cipherText;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private static String decryptData_ECB(String cipherText, boolean hexString, String secretKey) {
        try {
            SM4_Context ctx = new SM4_Context();
            ctx.isPadding = true;
            ctx.mode = 0;
            byte[] keyBytes = hexString ? SMUtil.hexStringToBytes(secretKey) : secretKey.getBytes();
            SM4 sm4 = new SM4();
            sm4.sm4_setkey_dec(ctx, keyBytes);
            byte[] decrypted = sm4.sm4_crypt_ecb(ctx, new BASE64Decoder().decodeBuffer(cipherText));
            return new String(decrypted, "UTF-8");
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private static String encryptData_CBC(String plainText, boolean hexString, String secretKey, String iv) {
        if (iv == null || iv.isEmpty()) {
            iv = IV;
        }
        try {
            byte[] ivBytes;
            byte[] keyBytes;
            SM4_Context ctx = new SM4_Context();
            ctx.isPadding = true;
            ctx.mode = 1;
            if (hexString) {
                keyBytes = SMUtil.hexStringToBytes(secretKey);
                ivBytes = SMUtil.hexStringToBytes(iv);
            } else {
                keyBytes = secretKey.getBytes();
                ivBytes = iv.getBytes();
            }
            SM4 sm4 = new SM4();
            sm4.sm4_setkey_enc(ctx, keyBytes);
            byte[] encrypted = sm4.sm4_crypt_cbc(ctx, ivBytes, plainText.getBytes("UTF-8"));
            String cipherText = new BASE64Encoder().encode(encrypted);
            if (cipherText != null && cipherText.trim().length() > 0) {
                Pattern p = Pattern.compile("\\s*|\t|\r|\n");
                Matcher m = p.matcher(cipherText);
                cipherText = m.replaceAll("");
            }
            return cipherText;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private static String decryptData_CBC(String cipherText, boolean hexString, String secretKey, String iv) {
        if (iv == null || iv.isEmpty()) {
            iv = IV;
        }
        try {
            byte[] ivBytes;
            byte[] keyBytes;
            SM4_Context ctx = new SM4_Context();
            ctx.isPadding = true;
            ctx.mode = 0;
            if (hexString) {
                keyBytes = SMUtil.hexStringToBytes(secretKey);
                ivBytes = SMUtil.hexStringToBytes(iv);
            } else {
                keyBytes = secretKey.getBytes();
                ivBytes = iv.getBytes();
            }
            SM4 sm4 = new SM4();
            sm4.sm4_setkey_dec(ctx, keyBytes);
            byte[] decrypted = sm4.sm4_crypt_cbc(ctx, ivBytes, new BASE64Decoder().decodeBuffer(cipherText));
            return new String(decrypted, "UTF-8");
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static byte[] hexStringToBytes(String hexString) {
        if (hexString == null || hexString.equals("")) {
            return null;
        }
        hexString = hexString.toUpperCase();
        int length = hexString.length() / 2;
        char[] hexChars = hexString.toCharArray();
        byte[] d = new byte[length];
        for (int i = 0; i < length; ++i) {
            int pos = i * 2;
            d[i] = (byte)(SMUtil.charToByte(hexChars[pos]) << 4 | SMUtil.charToByte(hexChars[pos + 1]));
        }
        return d;
    }

    public static byte charToByte(char c) {
        return (byte)"0123456789ABCDEF".indexOf(c);
    }

    public static SM2KeyPair generateKeyPair() {
        SM2 sm2 = new SM2();
        return sm2.generateKeyPair();
    }

    public static String SM2Encrypt(String data, SM2KeyPair keys) {
        SM2 sm2 = new SM2();
        byte[] encrypt = sm2.encrypt(data, keys.getPublicKey());
        return new String(Base64.encode(encrypt));
    }

    public static String SM2Decrypt(String data, SM2KeyPair keys) {
        SM2 sm2 = new SM2();
        return sm2.decrypt(Base64.decode(data), keys.getPrivateKey());
    }

    public static String SM3Encrypt(String data) throws IOException {
        return SM3.byteArrayToHexString(SM3.hash(data.getBytes()));
    }

    public static String SM4Encrypt(String data, String mode, String key, String iv) {
        if ("ECB".equals(mode)) {
            return SMUtil.encryptData_ECB(data, false, key);
        }
        if ("CBC".equals(mode)) {
            return SMUtil.encryptData_CBC(data, false, key, iv);
        }
        return null;
    }

    public static String SM4Decrypt(String data, String mode, String key, String iv) {
        if ("ECB".equals(mode)) {
            return SMUtil.decryptData_ECB(data, false, key);
        }
        if ("CBC".equals(mode)) {
            return SMUtil.decryptData_CBC(data, false, key, iv);
        }
        return null;
    }
}

