/*
 * Decompiled with CFR 0.152.
 */
package com.primeton.pmq.advisory;

import com.primeton.pmq.advisory.AdvisorySupport;
import com.primeton.pmq.advisory.ConsumerEventSource;
import com.primeton.pmq.advisory.DestinationEvent;
import com.primeton.pmq.advisory.DestinationListener;
import com.primeton.pmq.command.DataStructure;
import com.primeton.pmq.command.DestinationInfo;
import com.primeton.pmq.command.PMQDestination;
import com.primeton.pmq.command.PMQMessage;
import com.primeton.pmq.command.PMQQueue;
import com.primeton.pmq.command.PMQTempQueue;
import com.primeton.pmq.command.PMQTempTopic;
import com.primeton.pmq.command.PMQTopic;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.Session;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DestinationSource
implements MessageListener {
    private static final Logger LOG = LoggerFactory.getLogger(ConsumerEventSource.class);
    private AtomicBoolean started = new AtomicBoolean(false);
    private final Connection connection;
    private Session session;
    private MessageConsumer queueConsumer;
    private MessageConsumer topicConsumer;
    private MessageConsumer tempTopicConsumer;
    private MessageConsumer tempQueueConsumer;
    private Set<PMQQueue> queues = new CopyOnWriteArraySet<PMQQueue>();
    private Set<PMQTopic> topics = new CopyOnWriteArraySet<PMQTopic>();
    private Set<PMQTempQueue> temporaryQueues = new CopyOnWriteArraySet<PMQTempQueue>();
    private Set<PMQTempTopic> temporaryTopics = new CopyOnWriteArraySet<PMQTempTopic>();
    private DestinationListener listener;

    public DestinationSource(Connection connection) throws JMSException {
        this.connection = connection;
    }

    public DestinationListener getListener() {
        return this.listener;
    }

    public void setDestinationListener(DestinationListener listener) {
        this.listener = listener;
    }

    public Set<PMQQueue> getQueues() {
        return this.queues;
    }

    public Set<PMQTopic> getTopics() {
        return this.topics;
    }

    public Set<PMQTempQueue> getTemporaryQueues() {
        return this.temporaryQueues;
    }

    public Set<PMQTempTopic> getTemporaryTopics() {
        return this.temporaryTopics;
    }

    public void start() throws JMSException {
        if (this.started.compareAndSet(false, true)) {
            this.session = this.connection.createSession(false, 1);
            this.queueConsumer = this.session.createConsumer((Destination)AdvisorySupport.QUEUE_ADVISORY_TOPIC);
            this.queueConsumer.setMessageListener((MessageListener)this);
            this.topicConsumer = this.session.createConsumer((Destination)AdvisorySupport.TOPIC_ADVISORY_TOPIC);
            this.topicConsumer.setMessageListener((MessageListener)this);
            this.tempQueueConsumer = this.session.createConsumer((Destination)AdvisorySupport.TEMP_QUEUE_ADVISORY_TOPIC);
            this.tempQueueConsumer.setMessageListener((MessageListener)this);
            this.tempTopicConsumer = this.session.createConsumer((Destination)AdvisorySupport.TEMP_TOPIC_ADVISORY_TOPIC);
            this.tempTopicConsumer.setMessageListener((MessageListener)this);
        }
    }

    public void stop() throws JMSException {
        if (this.started.compareAndSet(true, false) && this.session != null) {
            this.session.close();
        }
    }

    public void onMessage(Message message) {
        if (message instanceof PMQMessage) {
            PMQMessage activeMessage = (PMQMessage)message;
            DataStructure command = activeMessage.getDataStructure();
            if (command instanceof DestinationInfo) {
                DestinationInfo destinationInfo = (DestinationInfo)command;
                DestinationEvent event = new DestinationEvent(this, destinationInfo);
                this.fireDestinationEvent(event);
            } else {
                LOG.warn("Unknown dataStructure: " + command);
            }
        } else {
            LOG.warn("Unknown message type: " + message + ". Message ignored");
        }
    }

    protected void fireDestinationEvent(DestinationEvent event) {
        PMQDestination destination = event.getDestination();
        boolean add = event.isAddOperation();
        if (destination instanceof PMQQueue) {
            PMQQueue queue2 = (PMQQueue)destination;
            if (add) {
                this.queues.add(queue2);
            } else {
                this.queues.remove(queue2);
            }
        } else if (destination instanceof PMQTopic) {
            PMQTopic topic = (PMQTopic)destination;
            if (add) {
                this.topics.add(topic);
            } else {
                this.topics.remove(topic);
            }
        } else if (destination instanceof PMQTempQueue) {
            PMQTempQueue queue3 = (PMQTempQueue)destination;
            if (add) {
                this.temporaryQueues.add(queue3);
            } else {
                this.temporaryQueues.remove(queue3);
            }
        } else if (destination instanceof PMQTempTopic) {
            PMQTempTopic topic = (PMQTempTopic)destination;
            if (add) {
                this.temporaryTopics.add(topic);
            } else {
                this.temporaryTopics.remove(topic);
            }
        } else {
            LOG.warn("Unknown destination type: " + destination);
        }
        if (this.listener != null) {
            this.listener.onDestinationEvent(event);
        }
    }
}

