/*
 * Decompiled with CFR 0.152.
 */
package com.primeton.pmq.advisory;

import com.primeton.pmq.Service;
import com.primeton.pmq.advisory.AdvisorySupport;
import com.primeton.pmq.advisory.ProducerEvent;
import com.primeton.pmq.advisory.ProducerListener;
import com.primeton.pmq.advisory.ProducerStartedEvent;
import com.primeton.pmq.advisory.ProducerStoppedEvent;
import com.primeton.pmq.command.DataStructure;
import com.primeton.pmq.command.PMQDestination;
import com.primeton.pmq.command.PMQMessage;
import com.primeton.pmq.command.PMQTopic;
import com.primeton.pmq.command.ProducerId;
import com.primeton.pmq.command.ProducerInfo;
import com.primeton.pmq.command.RemoveInfo;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.Session;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProducerEventSource
implements Service,
MessageListener {
    private static final Logger LOG = LoggerFactory.getLogger(ProducerEventSource.class);
    private final Connection connection;
    private final PMQDestination destination;
    private ProducerListener listener;
    private AtomicBoolean started = new AtomicBoolean(false);
    private AtomicInteger producerCount = new AtomicInteger();
    private Session session;
    private MessageConsumer consumer;

    public ProducerEventSource(Connection connection, Destination destination) throws JMSException {
        this.connection = connection;
        this.destination = PMQDestination.transform(destination);
    }

    public void setProducerListener(ProducerListener listener) {
        this.listener = listener;
    }

    @Override
    public void start() throws Exception {
        if (this.started.compareAndSet(false, true)) {
            this.session = this.connection.createSession(false, 1);
            PMQTopic advisoryTopic = AdvisorySupport.getProducerAdvisoryTopic(this.destination);
            this.consumer = this.session.createConsumer((Destination)advisoryTopic);
            this.consumer.setMessageListener((MessageListener)this);
        }
    }

    @Override
    public void stop() throws Exception {
        if (this.started.compareAndSet(true, false) && this.session != null) {
            this.session.close();
        }
    }

    public void onMessage(Message message) {
        if (message instanceof PMQMessage) {
            PMQMessage activeMessage = (PMQMessage)message;
            DataStructure command = activeMessage.getDataStructure();
            int count = 0;
            if (command instanceof ProducerInfo) {
                count = this.producerCount.incrementAndGet();
                count = this.extractProducerCountFromMessage(message, count);
                this.fireProducerEvent(new ProducerStartedEvent(this, this.destination, (ProducerInfo)command, count));
            } else if (command instanceof RemoveInfo) {
                RemoveInfo removeInfo = (RemoveInfo)command;
                if (removeInfo.isProducerRemove()) {
                    count = this.producerCount.decrementAndGet();
                    count = this.extractProducerCountFromMessage(message, count);
                    this.fireProducerEvent(new ProducerStoppedEvent(this, this.destination, (ProducerId)removeInfo.getObjectId(), count));
                }
            } else {
                LOG.warn("Unknown command: " + command);
            }
        } else {
            LOG.warn("Unknown message type: " + message + ". Message ignored");
        }
    }

    protected int extractProducerCountFromMessage(Message message, int count) {
        try {
            Object value = message.getObjectProperty("producerCount");
            if (value instanceof Number) {
                Number n = (Number)value;
                return n.intValue();
            }
            LOG.warn("No producerCount header available on the message: " + message);
        }
        catch (Exception e) {
            LOG.warn("Failed to extract producerCount from message: " + message + ".Reason: " + e, (Throwable)e);
        }
        return count;
    }

    protected void fireProducerEvent(ProducerEvent event) {
        if (this.listener != null) {
            this.listener.onProducerEvent(event);
        }
    }
}

