/*
 * Decompiled with CFR 0.152.
 */
package com.primeton.pmq.broker;

import com.primeton.pmq.broker.BrokerFactoryHandler;
import com.primeton.pmq.broker.BrokerService;
import com.primeton.pmq.util.IntrospectionSupport;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.Map;
import java.util.Properties;

public class PropertiesBrokerFactory
implements BrokerFactoryHandler {
    @Override
    public BrokerService createBroker(URI brokerURI) throws Exception {
        Map<Object, Object> properties = this.loadProperties(brokerURI);
        BrokerService brokerService = this.createBrokerService(brokerURI, properties);
        IntrospectionSupport.setProperties(brokerService, properties);
        return brokerService;
    }

    protected Map<Object, Object> loadProperties(URI brokerURI) throws IOException {
        String remaining = brokerURI.getSchemeSpecificPart();
        Properties properties = new Properties();
        File file = new File(remaining);
        try (InputStream inputStream = this.loadStream(file, remaining);){
            if (inputStream != null) {
                properties.load(inputStream);
            }
        }
        try {
            Properties systemProperties = System.getProperties();
            properties.putAll((Map<?, ?>)systemProperties);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return properties;
    }

    protected InputStream loadStream(File file, String remaining) throws IOException {
        InputStream inputStream = null;
        if (file != null && file.exists()) {
            inputStream = new FileInputStream(file);
        } else {
            URL url;
            block5: {
                url = null;
                try {
                    url = new URL(remaining);
                }
                catch (MalformedURLException e) {
                    inputStream = this.findResourceOnClassPath(remaining);
                    if (inputStream != null) break block5;
                    throw new IOException("File does not exist: " + remaining + ", could not be found on the classpath and is not a valid URL: " + e);
                }
            }
            if (inputStream == null && url != null) {
                inputStream = url.openStream();
            }
        }
        return inputStream;
    }

    protected InputStream findResourceOnClassPath(String remaining) {
        InputStream answer = Thread.currentThread().getContextClassLoader().getResourceAsStream(remaining);
        if (answer == null) {
            answer = this.getClass().getClassLoader().getResourceAsStream(remaining);
        }
        return answer;
    }

    protected BrokerService createBrokerService(URI brokerURI, Map<Object, Object> properties) {
        return new BrokerService();
    }
}

