/*
 * Decompiled with CFR 0.152.
 */
package com.primeton.pmq.broker;

import com.primeton.pmq.broker.Broker;
import com.primeton.pmq.broker.BrokerFilter;
import com.primeton.pmq.broker.ConnectionContext;
import com.primeton.pmq.broker.ProducerBrokerExchange;
import com.primeton.pmq.command.Message;
import com.primeton.pmq.jaas.UserPrincipal;
import com.primeton.pmq.security.SecurityContext;
import java.security.Principal;
import java.util.Set;

public class UserIDBroker
extends BrokerFilter {
    boolean useAuthenticatePrincipal = false;

    public UserIDBroker(Broker next) {
        super(next);
    }

    @Override
    public void send(ProducerBrokerExchange producerExchange, Message messageSend) throws Exception {
        Set<Principal> principals;
        SecurityContext securityContext;
        ConnectionContext context = producerExchange.getConnectionContext();
        String userID = context.getUserName();
        if (this.isUseAuthenticatePrincipal() && (securityContext = context.getSecurityContext()) != null && (principals = securityContext.getPrincipals()) != null) {
            for (Principal candidate : principals) {
                if (!(candidate instanceof UserPrincipal)) continue;
                userID = ((UserPrincipal)candidate).getName();
                break;
            }
        }
        messageSend.setUserID(userID);
        super.send(producerExchange, messageSend);
    }

    public boolean isUseAuthenticatePrincipal() {
        return this.useAuthenticatePrincipal;
    }

    public void setUseAuthenticatePrincipal(boolean useAuthenticatePrincipal) {
        this.useAuthenticatePrincipal = useAuthenticatePrincipal;
    }
}

