/*
 * Decompiled with CFR 0.152.
 */
package com.primeton.pmq.broker.jmx;

import com.primeton.pmq.broker.BrokerService;
import com.primeton.pmq.broker.ConnectionContext;
import com.primeton.pmq.broker.jmx.DurableSubscriptionView;
import com.primeton.pmq.broker.jmx.DurableSubscriptionViewMBean;
import com.primeton.pmq.broker.jmx.MBeanInfo;
import com.primeton.pmq.broker.jmx.ManagedRegionBroker;
import com.primeton.pmq.broker.region.Subscription;
import com.primeton.pmq.command.ConsumerInfo;
import com.primeton.pmq.command.RemoveSubscriptionInfo;
import com.primeton.pmq.command.SubscriptionInfo;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.TabularData;

public class InactiveDurableSubscriptionView
extends DurableSubscriptionView
implements DurableSubscriptionViewMBean {
    protected SubscriptionInfo subscriptionInfo;

    public InactiveDurableSubscriptionView(ManagedRegionBroker broker, BrokerService brokerService, String clientId, SubscriptionInfo subInfo, Subscription subscription) {
        super(broker, brokerService, clientId, null, subscription);
        this.broker = broker;
        this.subscriptionInfo = subInfo;
    }

    @Override
    public long getSubscriptionId() {
        return -1L;
    }

    @Override
    public String getDestinationName() {
        return this.subscriptionInfo.getDestination().getPhysicalName();
    }

    @Override
    public boolean isDestinationQueue() {
        return false;
    }

    @Override
    public boolean isDestinationTopic() {
        return true;
    }

    @Override
    public boolean isDestinationTemporary() {
        return false;
    }

    @Override
    public String getSubscriptionName() {
        return this.subscriptionInfo.getSubscriptionName();
    }

    @Override
    public boolean isActive() {
        return false;
    }

    @Override
    protected ConsumerInfo getConsumerInfo() {
        return null;
    }

    @Override
    public CompositeData[] browse() throws OpenDataException {
        return this.broker.browse(this);
    }

    @Override
    public TabularData browseAsTable() throws OpenDataException {
        return this.broker.browseAsTable(this);
    }

    @Override
    public void destroy() throws Exception {
        RemoveSubscriptionInfo info = new RemoveSubscriptionInfo();
        info.setClientId(this.clientId);
        info.setSubscriptionName(this.subscriptionInfo.getSubscriptionName());
        ConnectionContext context = new ConnectionContext();
        context.setBroker(this.broker);
        context.setClientId(this.clientId);
        this.brokerService.getBroker().removeSubscription(context, info);
    }

    @Override
    public String toString() {
        return "InactiveDurableSubscriptionView: " + this.getClientId() + ":" + this.getSubscriptionName();
    }

    @Override
    public String getSelector() {
        return this.subscriptionInfo.getSelector();
    }

    @Override
    public void removeMessage(@MBeanInfo(value="messageId") String messageId) throws Exception {
        this.broker.remove(this, messageId);
    }
}

