/*
 * Decompiled with CFR 0.152.
 */
package com.primeton.pmq.broker.region.policy;

import com.primeton.pmq.broker.region.MessageReference;
import com.primeton.pmq.broker.region.Subscription;
import com.primeton.pmq.broker.region.policy.SimpleDispatchPolicy;
import com.primeton.pmq.filter.MessageEvaluationContext;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class PriorityDispatchPolicy
extends SimpleDispatchPolicy {
    private final Comparator<? super Subscription> orderedCompare = new Comparator<Subscription>(){

        @Override
        public int compare(Subscription o1, Subscription o2) {
            return o2.getConsumerInfo().getPriority() - o1.getConsumerInfo().getPriority();
        }
    };

    @Override
    public boolean dispatch(MessageReference node, MessageEvaluationContext msgContext, List<Subscription> consumers) throws Exception {
        ArrayList<Subscription> ordered = new ArrayList<Subscription>(consumers);
        Collections.sort(ordered, this.orderedCompare);
        StringBuffer stringBuffer = new StringBuffer();
        for (Subscription sub : ordered) {
            stringBuffer.append(sub.getConsumerInfo().getPriority());
            stringBuffer.append(',');
        }
        return super.dispatch(node, msgContext, ordered);
    }
}

