/*
 * Decompiled with CFR 0.152.
 */
package com.primeton.pmq.broker.region.policy;

import com.primeton.pmq.broker.Broker;
import com.primeton.pmq.broker.ConnectionContext;
import com.primeton.pmq.broker.region.DurableTopicSubscription;
import com.primeton.pmq.broker.region.MessageReference;
import com.primeton.pmq.broker.region.SubscriptionRecovery;
import com.primeton.pmq.broker.region.Topic;
import com.primeton.pmq.broker.region.policy.SubscriptionRecoveryPolicy;
import com.primeton.pmq.command.Message;
import com.primeton.pmq.command.PMQDestination;
import com.primeton.pmq.filter.DestinationFilter;
import java.util.ArrayList;
import java.util.Arrays;

public class RetainedMessageSubscriptionRecoveryPolicy
implements SubscriptionRecoveryPolicy {
    public static final String RETAIN_PROPERTY = "PMQ.Retain";
    public static final String RETAINED_PROPERTY = "PMQ.Retained";
    private volatile MessageReference retainedMessage;
    private SubscriptionRecoveryPolicy wrapped;

    public RetainedMessageSubscriptionRecoveryPolicy(SubscriptionRecoveryPolicy wrapped) {
        this.wrapped = wrapped;
    }

    @Override
    public boolean add(ConnectionContext context, MessageReference node) throws Exception {
        boolean retain;
        Message message = node.getMessage();
        Object retainValue = message.getProperty(RETAIN_PROPERTY);
        boolean bl = retain = retainValue != null && Boolean.parseBoolean(retainValue.toString());
        if (retain) {
            if (message.getContent().getLength() > 0) {
                this.retainedMessage = message.copy();
                this.retainedMessage.getMessage().removeProperty(RETAIN_PROPERTY);
                this.retainedMessage.getMessage().setProperty(RETAINED_PROPERTY, true);
            } else {
                this.retainedMessage = null;
            }
            node.getMessage().removeProperty(RETAIN_PROPERTY);
        }
        return this.wrapped == null ? true : this.wrapped.add(context, node);
    }

    @Override
    public void recover(ConnectionContext context, Topic topic, SubscriptionRecovery sub) throws Exception {
        if (this.retainedMessage != null) {
            sub.addRecoveredMessage(context, this.retainedMessage);
        }
        if (this.wrapped != null) {
            boolean recover2 = true;
            if (sub instanceof DurableTopicSubscription && !((DurableTopicSubscription)sub).isEmpty(topic)) {
                recover2 = false;
            }
            if (recover2) {
                this.wrapped.recover(context, topic, sub);
            }
        }
    }

    @Override
    public void start() throws Exception {
        if (this.wrapped != null) {
            this.wrapped.start();
        }
    }

    @Override
    public void stop() throws Exception {
        if (this.wrapped != null) {
            this.wrapped.stop();
        }
    }

    @Override
    public Message[] browse(PMQDestination destination) throws Exception {
        Message[] wrappedMessages;
        DestinationFilter filter;
        ArrayList<Message> result = new ArrayList<Message>();
        if (this.retainedMessage != null && (filter = DestinationFilter.parseFilter(destination)).matches(this.retainedMessage.getMessage().getDestination())) {
            result.add(this.retainedMessage.getMessage());
        }
        Message[] messages = result.toArray(new Message[result.size()]);
        if (this.wrapped != null && (wrappedMessages = this.wrapped.browse(destination)) != null && wrappedMessages.length > 0) {
            int origLen = messages.length;
            messages = Arrays.copyOf(messages, origLen + wrappedMessages.length);
            System.arraycopy(wrappedMessages, 0, messages, origLen, wrappedMessages.length);
        }
        return messages;
    }

    @Override
    public SubscriptionRecoveryPolicy copy() {
        return new RetainedMessageSubscriptionRecoveryPolicy(this.wrapped);
    }

    @Override
    public void setBroker(Broker broker) {
    }

    public void setWrapped(SubscriptionRecoveryPolicy wrapped) {
        this.wrapped = wrapped;
    }

    public SubscriptionRecoveryPolicy getWrapped() {
        return this.wrapped;
    }
}

