/*
 * Decompiled with CFR 0.152.
 */
package com.primeton.pmq.broker.region.virtual;

import com.primeton.pmq.broker.ConnectionContext;
import com.primeton.pmq.broker.region.BaseDestination;
import com.primeton.pmq.broker.region.Destination;
import com.primeton.pmq.broker.region.DestinationFilter;
import com.primeton.pmq.broker.region.IndirectMessageReference;
import com.primeton.pmq.broker.region.RegionBroker;
import com.primeton.pmq.broker.region.Subscription;
import com.primeton.pmq.broker.region.Topic;
import com.primeton.pmq.command.Message;
import com.primeton.pmq.command.PMQDestination;
import com.primeton.pmq.util.SubscriptionKey;
import java.util.Set;

public class MappedQueueFilter
extends DestinationFilter {
    private final PMQDestination virtualDestination;

    public MappedQueueFilter(PMQDestination virtualDestination, Destination destination) {
        super(destination);
        this.virtualDestination = virtualDestination;
    }

    @Override
    public synchronized void addSubscription(ConnectionContext context, Subscription sub) throws Exception {
        boolean noSubs = this.getConsumers().isEmpty();
        int match = sub.getPMQDestination().compareTo(this.next.getPMQDestination());
        if (match == 0 || !this.next.getPMQDestination().isPattern() && match == 1) {
            super.addSubscription(context, sub);
        }
        if (noSubs && !this.getConsumers().isEmpty()) {
            RegionBroker regionBroker = (RegionBroker)context.getBroker().getAdaptor(RegionBroker.class);
            Set<Destination> virtualDests = regionBroker.getDestinations(this.virtualDestination);
            PMQDestination newDestination = sub.getPMQDestination();
            BaseDestination regionDest = null;
            for (Destination virtualDest : virtualDests) {
                Message[] messages;
                Topic topic;
                if (!virtualDest.getPMQDestination().isTopic() || !virtualDest.isAlwaysRetroactive() && !sub.getConsumerInfo().isRetroactive() || (topic = (Topic)this.getBaseDestination(virtualDest)) == null) continue;
                for (Message message : messages = topic.getSubscriptionRecoveryPolicy().browse(topic.getPMQDestination())) {
                    Message copy = message.copy();
                    copy.setOriginalDestination(message.getDestination());
                    copy.setDestination(newDestination);
                    if (regionDest == null) {
                        regionDest = this.getBaseDestination((Destination)regionBroker.getDestinations(newDestination).toArray()[0]);
                    }
                    copy.setRegionDestination(regionDest);
                    sub.addRecoveredMessage(context, newDestination.isQueue() ? new IndirectMessageReference(copy) : copy);
                }
            }
        }
    }

    private BaseDestination getBaseDestination(Destination virtualDest) {
        if (virtualDest instanceof BaseDestination) {
            return (BaseDestination)virtualDest;
        }
        if (virtualDest instanceof DestinationFilter) {
            return ((DestinationFilter)virtualDest).getAdaptor(BaseDestination.class);
        }
        return null;
    }

    @Override
    public synchronized void removeSubscription(ConnectionContext context, Subscription sub, long lastDeliveredSequenceId) throws Exception {
        super.removeSubscription(context, sub, lastDeliveredSequenceId);
    }

    @Override
    public synchronized void deleteSubscription(ConnectionContext context, SubscriptionKey key) throws Exception {
        super.deleteSubscription(context, key);
    }

    public String toString() {
        return "MappedQueueFilter[" + this.virtualDestination + ", " + this.next + "]";
    }
}

