/*
 * Decompiled with CFR 0.152.
 */
package com.primeton.pmq.broker.util;

import com.primeton.pmq.broker.BrokerPluginSupport;
import com.primeton.pmq.broker.ConnectionContext;
import com.primeton.pmq.broker.ConsumerBrokerExchange;
import com.primeton.pmq.broker.ProducerBrokerExchange;
import com.primeton.pmq.broker.region.Destination;
import com.primeton.pmq.broker.region.Subscription;
import com.primeton.pmq.command.ConsumerControl;
import com.primeton.pmq.command.ConsumerInfo;
import com.primeton.pmq.command.DestinationInfo;
import com.primeton.pmq.command.Message;
import com.primeton.pmq.command.MessageAck;
import com.primeton.pmq.command.MessagePull;
import com.primeton.pmq.command.PMQDestination;
import com.primeton.pmq.command.ProducerInfo;
import com.primeton.pmq.command.Response;
import com.primeton.pmq.filter.DestinationPath;
import java.util.ArrayList;
import java.util.StringTokenizer;

public class DestinationPathSeparatorBroker
extends BrokerPluginSupport {
    String pathSeparator = "/";

    protected PMQDestination convertDestination(PMQDestination destination) {
        if (destination != null && destination.getPhysicalName().contains(this.pathSeparator)) {
            ArrayList<String> l = new ArrayList<String>();
            StringTokenizer iter = new StringTokenizer(destination.getPhysicalName(), this.pathSeparator);
            while (iter.hasMoreTokens()) {
                String name = iter.nextToken().trim();
                if (name.length() == 0) continue;
                l.add(name);
            }
            String newName = DestinationPath.toString(l.toArray(new String[l.size()]));
            return PMQDestination.createDestination(newName, destination.getDestinationType());
        }
        return destination;
    }

    @Override
    public void acknowledge(ConsumerBrokerExchange consumerExchange, MessageAck ack) throws Exception {
        ack.setDestination(this.convertDestination(ack.getDestination()));
        super.acknowledge(consumerExchange, ack);
    }

    @Override
    public Subscription addConsumer(ConnectionContext context, ConsumerInfo info) throws Exception {
        info.setDestination(this.convertDestination(info.getDestination()));
        return super.addConsumer(context, info);
    }

    @Override
    public void addProducer(ConnectionContext context, ProducerInfo info) throws Exception {
        info.setDestination(this.convertDestination(info.getDestination()));
        super.addProducer(context, info);
    }

    @Override
    public void removeConsumer(ConnectionContext context, ConsumerInfo info) throws Exception {
        info.setDestination(this.convertDestination(info.getDestination()));
        super.removeConsumer(context, info);
    }

    @Override
    public void removeProducer(ConnectionContext context, ProducerInfo info) throws Exception {
        info.setDestination(this.convertDestination(info.getDestination()));
        super.removeProducer(context, info);
    }

    @Override
    public void send(ProducerBrokerExchange producerExchange, Message messageSend) throws Exception {
        messageSend.setDestination(this.convertDestination(messageSend.getDestination()));
        super.send(producerExchange, messageSend);
    }

    @Override
    public Destination addDestination(ConnectionContext context, PMQDestination destination, boolean createIfTemporary) throws Exception {
        return super.addDestination(context, this.convertDestination(destination), createIfTemporary);
    }

    @Override
    public void removeDestination(ConnectionContext context, PMQDestination destination, long timeout) throws Exception {
        super.removeDestination(context, this.convertDestination(destination), timeout);
    }

    @Override
    public void addDestinationInfo(ConnectionContext context, DestinationInfo info) throws Exception {
        info.setDestination(this.convertDestination(info.getDestination()));
        super.addDestinationInfo(context, info);
    }

    @Override
    public void removeDestinationInfo(ConnectionContext context, DestinationInfo info) throws Exception {
        info.setDestination(this.convertDestination(info.getDestination()));
        super.removeDestinationInfo(context, info);
    }

    @Override
    public void processConsumerControl(ConsumerBrokerExchange consumerExchange, ConsumerControl control) {
        control.setDestination(this.convertDestination(control.getDestination()));
        super.processConsumerControl(consumerExchange, control);
    }

    @Override
    public Response messagePull(ConnectionContext context, MessagePull pull) throws Exception {
        pull.setDestination(this.convertDestination(pull.getDestination()));
        return super.messagePull(context, pull);
    }

    public void setPathSeparator(String pathSeparator) {
        this.pathSeparator = pathSeparator;
    }
}

