/*
 * Decompiled with CFR 0.152.
 */
package com.primeton.pmq.broker.util;

import com.primeton.pmq.RedeliveryPolicy;
import com.primeton.pmq.broker.Broker;
import com.primeton.pmq.broker.BrokerPluginSupport;
import com.primeton.pmq.broker.ConnectionContext;
import com.primeton.pmq.broker.ProducerBrokerExchange;
import com.primeton.pmq.broker.region.Destination;
import com.primeton.pmq.broker.region.MessageReference;
import com.primeton.pmq.broker.region.Subscription;
import com.primeton.pmq.broker.region.policy.RedeliveryPolicyMap;
import com.primeton.pmq.command.Message;
import com.primeton.pmq.command.PMQDestination;
import com.primeton.pmq.command.PMQQueue;
import com.primeton.pmq.command.PMQTopic;
import com.primeton.pmq.command.ProducerInfo;
import com.primeton.pmq.filter.AnyDestination;
import com.primeton.pmq.state.ProducerState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RedeliveryPlugin
extends BrokerPluginSupport {
    private static final Logger LOG = LoggerFactory.getLogger(RedeliveryPlugin.class);
    public static final String REDELIVERY_DELAY = "redeliveryDelay";
    RedeliveryPolicyMap redeliveryPolicyMap = new RedeliveryPolicyMap();
    boolean sendToDlqIfMaxRetriesExceeded = true;
    private boolean fallbackToDeadLetter = true;

    @Override
    public Broker installPlugin(Broker broker) throws Exception {
        if (!broker.getBrokerService().isSchedulerSupport()) {
            throw new IllegalStateException("RedeliveryPlugin requires schedulerSupport=true on the broker");
        }
        this.validatePolicyDelay(1000L);
        return super.installPlugin(broker);
    }

    private void validatePolicyDelay(long limit) {
        AnyDestination matchAll = new AnyDestination(new PMQDestination[]{new PMQQueue(">"), new PMQTopic(">")});
        for (Object entry : this.redeliveryPolicyMap.get(matchAll)) {
            RedeliveryPolicy redeliveryPolicy = (RedeliveryPolicy)entry;
            this.validateLimit(limit, redeliveryPolicy);
        }
        RedeliveryPolicy defaultEntry = this.redeliveryPolicyMap.getDefaultEntry();
        if (defaultEntry != null) {
            this.validateLimit(limit, defaultEntry);
        }
    }

    private void validateLimit(long limit, RedeliveryPolicy redeliveryPolicy) {
        if (redeliveryPolicy.getInitialRedeliveryDelay() < limit) {
            throw new IllegalStateException("RedeliveryPolicy initialRedeliveryDelay must exceed: " + limit + ". " + redeliveryPolicy);
        }
        if (redeliveryPolicy.getRedeliveryDelay() < limit) {
            throw new IllegalStateException("RedeliveryPolicy redeliveryDelay must exceed: " + limit + ". " + redeliveryPolicy);
        }
    }

    public RedeliveryPolicyMap getRedeliveryPolicyMap() {
        return this.redeliveryPolicyMap;
    }

    public void setRedeliveryPolicyMap(RedeliveryPolicyMap redeliveryPolicyMap) {
        this.redeliveryPolicyMap = redeliveryPolicyMap;
    }

    public boolean isSendToDlqIfMaxRetriesExceeded() {
        return this.sendToDlqIfMaxRetriesExceeded;
    }

    public void setSendToDlqIfMaxRetriesExceeded(boolean sendToDlqIfMaxRetriesExceeded) {
        this.sendToDlqIfMaxRetriesExceeded = sendToDlqIfMaxRetriesExceeded;
    }

    public boolean isFallbackToDeadLetter() {
        return this.fallbackToDeadLetter;
    }

    public void setFallbackToDeadLetter(boolean fallbackToDeadLetter) {
        this.fallbackToDeadLetter = fallbackToDeadLetter;
    }

    @Override
    public boolean sendToDeadLetterQueue(ConnectionContext context, MessageReference messageReference, Subscription subscription, Throwable poisonCause) {
        if (messageReference.isExpired()) {
            return super.sendToDeadLetterQueue(context, messageReference, subscription, poisonCause);
        }
        try {
            Destination regionDestination = (Destination)messageReference.getRegionDestination();
            RedeliveryPolicy redeliveryPolicy = this.redeliveryPolicyMap.getEntryFor(regionDestination.getPMQDestination());
            if (redeliveryPolicy != null) {
                int maximumRedeliveries = redeliveryPolicy.getMaximumRedeliveries();
                int redeliveryCount = messageReference.getRedeliveryCounter();
                if (-1 == maximumRedeliveries || redeliveryCount < maximumRedeliveries) {
                    long delay = redeliveryPolicy.getInitialRedeliveryDelay();
                    for (int i = 0; i < redeliveryCount; ++i) {
                        delay = redeliveryPolicy.getNextRedeliveryDelay(delay);
                    }
                    this.scheduleRedelivery(context, messageReference, delay, ++redeliveryCount);
                } else {
                    if (this.isSendToDlqIfMaxRetriesExceeded()) {
                        return super.sendToDeadLetterQueue(context, messageReference, subscription, poisonCause);
                    }
                    LOG.debug("Discarding message that exceeds max redelivery count({}), {}", (Object)maximumRedeliveries, (Object)messageReference.getMessageId());
                }
            } else {
                if (this.isFallbackToDeadLetter()) {
                    return super.sendToDeadLetterQueue(context, messageReference, subscription, poisonCause);
                }
                LOG.debug("Ignoring dlq request for: {}, RedeliveryPolicy not found (and no fallback) for: {}", (Object)messageReference.getMessageId(), (Object)regionDestination.getPMQDestination());
            }
            return false;
        }
        catch (Exception exception) {
            RuntimeException toThrow = new RuntimeException("Failed to schedule redelivery for: " + messageReference.getMessageId(), exception);
            LOG.error(toThrow.toString(), (Throwable)exception);
            throw toThrow;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scheduleRedelivery(ConnectionContext context, MessageReference messageReference, long delay, int redeliveryCount) throws Exception {
        if (LOG.isTraceEnabled()) {
            Destination regionDestination = (Destination)messageReference.getRegionDestination();
            LOG.trace("redelivery #{} of: {} with delay: {}, dest: {}", new Object[]{redeliveryCount, messageReference.getMessageId(), delay, regionDestination.getPMQDestination()});
        }
        Message old = messageReference.getMessage();
        Message message = old.copy();
        message.setTransactionId(null);
        message.setMemoryUsage(null);
        message.removeProperty("scheduledJobId");
        message.setProperty(REDELIVERY_DELAY, delay);
        message.setProperty("PMQ_SCHEDULED_DELAY", delay);
        message.setRedeliveryCounter(redeliveryCount);
        boolean originalFlowControl = context.isProducerFlowControl();
        try {
            context.setProducerFlowControl(false);
            ProducerInfo info = new ProducerInfo();
            ProducerState state = new ProducerState(info);
            ProducerBrokerExchange producerExchange = new ProducerBrokerExchange();
            producerExchange.setProducerState(state);
            producerExchange.setMutable(true);
            producerExchange.setConnectionContext(context);
            context.getBroker().send(producerExchange, message);
        }
        finally {
            context.setProducerFlowControl(originalFlowControl);
        }
    }
}

