/*
 * Decompiled with CFR 0.152.
 */
package com.primeton.pmq.broker.view;

import com.primeton.pmq.broker.BrokerRegistry;
import com.primeton.pmq.broker.BrokerService;
import com.primeton.pmq.broker.region.Destination;
import com.primeton.pmq.broker.view.BrokerDestinationView;
import com.primeton.pmq.command.PMQDestination;
import com.primeton.pmq.command.PMQQueue;
import com.primeton.pmq.command.PMQTempQueue;
import com.primeton.pmq.command.PMQTempTopic;
import com.primeton.pmq.command.PMQTopic;
import com.primeton.pmq.util.LRUCache;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class MessageBrokerView {
    private final BrokerService brokerService;
    private final Map<PMQDestination, BrokerDestinationView> destinationViewMap = new LRUCache<PMQDestination, BrokerDestinationView>();

    public MessageBrokerView(BrokerService brokerService) {
        this.brokerService = brokerService;
        if (brokerService == null) {
            throw new NullPointerException("BrokerService is null");
        }
        if (!brokerService.isStarted()) {
            throw new IllegalStateException("BrokerService " + brokerService.getBrokerName() + " is not started");
        }
    }

    public MessageBrokerView(String brokerName) {
        this.brokerService = BrokerRegistry.getInstance().lookup(brokerName);
        if (this.brokerService == null) {
            throw new NullPointerException("BrokerService is null");
        }
        if (!this.brokerService.isStarted()) {
            throw new IllegalStateException("BrokerService " + this.brokerService.getBrokerName() + " is not started");
        }
    }

    public String getBrokerName() {
        return this.brokerService.getBrokerName();
    }

    public String getBrokerId() {
        try {
            return this.brokerService.getBroker().getBrokerId().toString();
        }
        catch (Exception e) {
            return "";
        }
    }

    public int getMemoryPercentUsage() {
        return this.brokerService.getSystemUsage().getMemoryUsage().getPercentUsage();
    }

    public int getStorePercentUsage() {
        return this.brokerService.getSystemUsage().getStoreUsage().getPercentUsage();
    }

    public int getTempPercentUsage() {
        return this.brokerService.getSystemUsage().getTempUsage().getPercentUsage();
    }

    public int getJobSchedulerStorePercentUsage() {
        return this.brokerService.getSystemUsage().getJobSchedulerUsage().getPercentUsage();
    }

    public boolean isPersistent() {
        return this.brokerService.isPersistent();
    }

    public BrokerService getBrokerService() {
        return this.brokerService;
    }

    public Set<PMQDestination> getDestinations() {
        Set<PMQDestination> result;
        try {
            PMQDestination[] destinations = this.brokerService.getBroker().getDestinations();
            result = new HashSet<PMQDestination>();
            Collections.addAll(result, destinations);
        }
        catch (Exception e) {
            result = Collections.emptySet();
        }
        return result;
    }

    public Set<PMQTopic> getTopics() {
        HashSet<PMQTopic> result = new HashSet<PMQTopic>();
        for (PMQDestination destination : this.getDestinations()) {
            if (!destination.isTopic() || destination.isTemporary()) continue;
            result.add((PMQTopic)destination);
        }
        return result;
    }

    public Set<PMQQueue> getQueues() {
        HashSet<PMQQueue> result = new HashSet<PMQQueue>();
        for (PMQDestination destination : this.getDestinations()) {
            if (!destination.isQueue() || destination.isTemporary()) continue;
            result.add((PMQQueue)destination);
        }
        return result;
    }

    public Set<PMQTempTopic> getTempTopics() {
        HashSet<PMQTempTopic> result = new HashSet<PMQTempTopic>();
        for (PMQDestination destination : this.getDestinations()) {
            if (!destination.isTopic() || !destination.isTemporary()) continue;
            result.add((PMQTempTopic)destination);
        }
        return result;
    }

    public Set<PMQTempQueue> getTempQueues() {
        HashSet<PMQTempQueue> result = new HashSet<PMQTempQueue>();
        for (PMQDestination destination : this.getDestinations()) {
            if (!destination.isQueue() || !destination.isTemporary()) continue;
            result.add((PMQTempQueue)destination);
        }
        return result;
    }

    public BrokerDestinationView getDestinationView(String destinationName) throws Exception {
        return this.getDestinationView(destinationName, (byte)1);
    }

    public BrokerDestinationView getTopicDestinationView(String destinationName) throws Exception {
        return this.getDestinationView(destinationName, (byte)2);
    }

    public BrokerDestinationView getQueueDestinationView(String destinationName) throws Exception {
        return this.getDestinationView(destinationName, (byte)1);
    }

    public BrokerDestinationView getDestinationView(String destinationName, byte type) throws Exception {
        PMQDestination pmqDestination = PMQDestination.createDestination(destinationName, type);
        return this.getDestinationView(pmqDestination);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BrokerDestinationView getDestinationView(PMQDestination pmqDestination) throws Exception {
        BrokerDestinationView view = null;
        Map<PMQDestination, BrokerDestinationView> map = this.destinationViewMap;
        synchronized (map) {
            view = this.destinationViewMap.get(pmqDestination);
            if (view == null) {
                Destination destination = this.brokerService.getDestination(pmqDestination);
                view = new BrokerDestinationView(destination);
                this.destinationViewMap.put(pmqDestination, view);
            }
        }
        return view;
    }
}

