/*
 * Decompiled with CFR 0.152.
 */
package com.primeton.pmq.camel.component.broker;

import com.primeton.pmq.broker.ProducerBrokerExchange;
import com.primeton.pmq.broker.inteceptor.MessageInterceptor;
import com.primeton.pmq.broker.inteceptor.MessageInterceptorRegistry;
import com.primeton.pmq.camel.component.broker.BrokerComponent;
import com.primeton.pmq.camel.component.broker.BrokerConfiguration;
import com.primeton.pmq.camel.component.broker.BrokerConsumer;
import com.primeton.pmq.camel.component.broker.BrokerProducer;
import com.primeton.pmq.command.Message;
import com.primeton.pmq.command.PMQDestination;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Endpoint;
import org.apache.camel.MultipleConsumersSupport;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.Service;
import org.apache.camel.api.management.ManagedResource;
import org.apache.camel.impl.DefaultEndpoint;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriPath;
import org.apache.camel.util.UnsafeUriCharactersEncoder;

@ManagedResource(description="Managed Camel Broker Endpoint")
@UriEndpoint(scheme="broker", syntax="broker:destination", consumerClass=BrokerConsumer.class, title="Broker", label="messaging")
public class BrokerEndpoint
extends DefaultEndpoint
implements MultipleConsumersSupport,
Service {
    static final String PRODUCER_BROKER_EXCHANGE = "producerBrokerExchange";
    private MessageInterceptorRegistry messageInterceptorRegistry;
    private List<MessageInterceptor> messageInterceptorList = new CopyOnWriteArrayList<MessageInterceptor>();
    @UriPath(name="destination")
    @Metadata(required="true")
    private String destinationName;
    private final PMQDestination destination;
    @UriParam
    private final BrokerConfiguration configuration;

    public BrokerEndpoint(String uri, BrokerComponent component, String destinationName, PMQDestination destination, BrokerConfiguration configuration) {
        super(UnsafeUriCharactersEncoder.encode((String)uri), (Component)component);
        this.destinationName = destinationName;
        this.destination = destination;
        this.configuration = configuration;
    }

    public Producer createProducer() throws Exception {
        BrokerProducer producer = new BrokerProducer(this);
        return producer;
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        BrokerConsumer consumer = new BrokerConsumer((Endpoint)this, processor);
        this.configureConsumer((Consumer)consumer);
        return consumer;
    }

    public boolean isSingleton() {
        return false;
    }

    public boolean isMultipleConsumersSupported() {
        return true;
    }

    public PMQDestination getDestination() {
        return this.destination;
    }

    public String getDestinationName() {
        return this.destinationName;
    }

    protected void doStart() throws Exception {
        super.doStart();
        this.messageInterceptorRegistry = MessageInterceptorRegistry.getInstance().get(this.configuration.getBrokerName());
        for (MessageInterceptor messageInterceptor : this.messageInterceptorList) {
            this.addMessageInterceptor(messageInterceptor);
        }
        this.messageInterceptorList.clear();
    }

    protected void doStop() throws Exception {
        super.doStop();
    }

    protected void addMessageInterceptor(MessageInterceptor messageInterceptor) {
        if (this.isStarted()) {
            this.messageInterceptorRegistry.addMessageInterceptor(this.destination, messageInterceptor);
        } else {
            this.messageInterceptorList.add(messageInterceptor);
        }
    }

    protected void removeMessageInterceptor(MessageInterceptor messageInterceptor) {
        this.messageInterceptorRegistry.removeMessageInterceptor(this.destination, messageInterceptor);
    }

    protected void inject(ProducerBrokerExchange producerBrokerExchange, Message message) throws Exception {
        ProducerBrokerExchange pbe = producerBrokerExchange;
        if (message != null) {
            message.setDestination(this.destination);
            if (producerBrokerExchange != null && producerBrokerExchange.getRegionDestination() != null && !producerBrokerExchange.getRegionDestination().getPMQDestination().equals(this.destination)) {
                pbe = null;
            }
            this.messageInterceptorRegistry.injectMessage(pbe, message);
        }
    }
}

