/*
 * Decompiled with CFR 0.152.
 */
package com.primeton.pmq.camel.component.broker;

import com.primeton.pmq.broker.ProducerBrokerExchange;
import com.primeton.pmq.camel.component.broker.BrokerEndpoint;
import com.primeton.pmq.command.PMQMessage;
import java.util.Map;
import javax.jms.JMSException;
import org.apache.camel.AsyncCallback;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.component.jms.JmsMessage;
import org.apache.camel.impl.DefaultAsyncProducer;

public class BrokerProducer
extends DefaultAsyncProducer {
    private final BrokerEndpoint brokerEndpoint;

    public BrokerProducer(BrokerEndpoint endpoint) {
        super((Endpoint)endpoint);
        this.brokerEndpoint = endpoint;
    }

    public boolean process(Exchange exchange, AsyncCallback callback) {
        try {
            return this.processInOnly(exchange, callback);
        }
        catch (Throwable e) {
            exchange.setException(e);
            callback.done(true);
            return true;
        }
    }

    protected boolean processInOnly(Exchange exchange, AsyncCallback callback) {
        try {
            PMQMessage message = this.getMessage(exchange);
            if (message != null) {
                message.setDestination(this.brokerEndpoint.getDestination());
                ProducerBrokerExchange producerBrokerExchange = (ProducerBrokerExchange)exchange.getProperty("producerBrokerExchange");
                this.brokerEndpoint.inject(producerBrokerExchange, message);
            }
        }
        catch (Exception e) {
            exchange.setException((Throwable)e);
        }
        callback.done(true);
        return true;
    }

    private PMQMessage getMessage(Exchange exchange) throws IllegalStateException, JMSException {
        Message camelMessage = this.getMessageFromExchange(exchange);
        this.checkOriginalMessage(camelMessage);
        PMQMessage result = (PMQMessage)((JmsMessage)camelMessage).getJmsMessage();
        this.applyNewHeaders(result, camelMessage.getHeaders());
        return result;
    }

    private Message getMessageFromExchange(Exchange exchange) {
        if (exchange.hasOut()) {
            return exchange.getOut();
        }
        return exchange.getIn();
    }

    private void checkOriginalMessage(Message camelMessage) throws IllegalStateException {
        if (!(camelMessage instanceof JmsMessage)) {
            throw new IllegalStateException("Not the original message from the broker " + camelMessage);
        }
        javax.jms.Message message = ((JmsMessage)camelMessage).getJmsMessage();
        if (!(message instanceof PMQMessage)) {
            throw new IllegalStateException("Not the original message from the broker " + message);
        }
    }

    private void applyNewHeaders(PMQMessage message, Map<String, Object> headers) throws JMSException {
        for (Map.Entry<String, Object> entry : headers.entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            if (value == null) continue;
            message.setObjectProperty(key, value.toString(), false);
        }
    }
}

