/*
 * Decompiled with CFR 0.152.
 */
package com.primeton.pmq.command;

import com.primeton.pmq.command.PMQDestination;
import com.primeton.pmq.command.PMQQueue;
import com.primeton.pmq.command.PMQTopic;
import com.primeton.pmq.command.UnresolvedDestinationTransformer;
import java.lang.reflect.Method;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Queue;
import javax.jms.Topic;

public class DefaultUnresolvedDestinationTransformer
implements UnresolvedDestinationTransformer {
    @Override
    public PMQDestination transform(Destination dest) throws JMSException {
        String queueName = ((Queue)dest).getQueueName();
        String topicName = ((Topic)dest).getTopicName();
        if (queueName == null && topicName == null) {
            throw new JMSException("Unresolvable destination: Both queue and topic names are null: " + dest);
        }
        try {
            Method isQueueMethod = dest.getClass().getMethod("isQueue", new Class[0]);
            Method isTopicMethod = dest.getClass().getMethod("isTopic", new Class[0]);
            Boolean isQueue = (Boolean)isQueueMethod.invoke((Object)dest, new Object[0]);
            Boolean isTopic = (Boolean)isTopicMethod.invoke((Object)dest, new Object[0]);
            if (isQueue.booleanValue()) {
                return new PMQQueue(queueName);
            }
            if (isTopic.booleanValue()) {
                return new PMQTopic(topicName);
            }
            throw new JMSException("Unresolvable destination: Neither Queue nor Topic: " + dest);
        }
        catch (Exception e) {
            throw new JMSException("Unresolvable destination: " + e.getMessage() + ": " + dest);
        }
    }

    @Override
    public PMQDestination transform(String dest) throws JMSException {
        return new PMQQueue(dest);
    }
}

