/*
 * Decompiled with CFR 0.152.
 */
package com.primeton.pmq.console.command;

import com.primeton.pmq.console.command.AbstractCommand;
import java.io.File;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import javax.management.MBeanServerConnection;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;

public abstract class AbstractJmxCommand
extends AbstractCommand {
    public static String DEFAULT_JMX_URL = System.getProperty("pmq.jmx.url", "service:jmx:rmi:///jndi/rmi://localhost:1099/jmxrmi");
    private static String jmxUser = System.getProperty("pmq.jmx.user");
    private static String jmxPassword = System.getProperty("pmq.jmx.password");
    private static boolean jmxUseLocal = Boolean.parseBoolean(System.getProperty("pmq.jmx.useLocal", "false"));
    private static final String CONNECTOR_ADDRESS = "com.sun.management.jmxremote.localConnectorAddress";
    private JMXServiceURL jmxServiceUrl;
    private JMXConnector jmxConnector;
    private MBeanServerConnection jmxConnection;

    protected JMXServiceURL getJmxServiceUrl() {
        return this.jmxServiceUrl;
    }

    public static String getJVM() {
        return System.getProperty("java.vm.specification.vendor");
    }

    public static boolean isSunJVM() {
        return AbstractJmxCommand.getJVM().equals("Sun Microsystems Inc.") || AbstractJmxCommand.getJVM().startsWith("Oracle");
    }

    protected String findJMXUrlByProcessId(int pid) {
        if (AbstractJmxCommand.isSunJVM()) {
            try {
                String javaHome = System.getProperty("java.home");
                String tools = javaHome + File.separator + ".." + File.separator + "lib" + File.separator + "tools.jar";
                URLClassLoader loader = new URLClassLoader(new URL[]{new File(tools).toURI().toURL()});
                Class<?> virtualMachine = Class.forName("com.sun.tools.attach.VirtualMachine", true, loader);
                Class<?> virtualMachineDescriptor = Class.forName("com.sun.tools.attach.VirtualMachineDescriptor", true, loader);
                Method getVMList = virtualMachine.getMethod("list", null);
                Method attachToVM = virtualMachine.getMethod("attach", String.class);
                Method getAgentProperties = virtualMachine.getMethod("getAgentProperties", null);
                Method getVMId = virtualMachineDescriptor.getMethod("id", null);
                List allVMs = (List)getVMList.invoke(null, (Object[])null);
                for (Object vmInstance : allVMs) {
                    String id = (String)getVMId.invoke(vmInstance, (Object[])null);
                    if (!id.equals(Integer.toString(pid))) continue;
                    Object vm = attachToVM.invoke(null, id);
                    Properties agentProperties = (Properties)getAgentProperties.invoke(vm, (Object[])null);
                    String connectorAddress = agentProperties.getProperty(CONNECTOR_ADDRESS);
                    if (connectorAddress == null) break;
                    return connectorAddress;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    protected JMXServiceURL useJmxServiceUrl() throws MalformedURLException {
        if (this.getJmxServiceUrl() == null) {
            String jmxUrl = DEFAULT_JMX_URL;
            int connectingPid = -1;
            if (AbstractJmxCommand.isSunJVM()) {
                try {
                    String javaHome = System.getProperty("java.home");
                    String tools = javaHome + File.separator + ".." + File.separator + "lib" + File.separator + "tools.jar";
                    URLClassLoader loader = new URLClassLoader(new URL[]{new File(tools).toURI().toURL()});
                    Class<?> virtualMachine = Class.forName("com.sun.tools.attach.VirtualMachine", true, loader);
                    Class<?> virtualMachineDescriptor = Class.forName("com.sun.tools.attach.VirtualMachineDescriptor", true, loader);
                    Method getVMList = virtualMachine.getMethod("list", null);
                    Method attachToVM = virtualMachine.getMethod("attach", String.class);
                    Method getAgentProperties = virtualMachine.getMethod("getAgentProperties", null);
                    Method getVMDescriptor = virtualMachineDescriptor.getMethod("displayName", null);
                    Method getVMId = virtualMachineDescriptor.getMethod("id", null);
                    List allVMs = (List)getVMList.invoke(null, (Object[])null);
                    for (Object vmInstance : allVMs) {
                        String displayName = (String)getVMDescriptor.invoke(vmInstance, (Object[])null);
                        if (!displayName.contains("pmq.jar start")) continue;
                        String id = (String)getVMId.invoke(vmInstance, (Object[])null);
                        Object vm = attachToVM.invoke(null, id);
                        Properties agentProperties = (Properties)getAgentProperties.invoke(vm, (Object[])null);
                        String connectorAddress = agentProperties.getProperty(CONNECTOR_ADDRESS);
                        if (connectorAddress == null) continue;
                        jmxUrl = connectorAddress;
                        connectingPid = Integer.parseInt(id);
                        this.context.print("useJmxServiceUrl Found JMS Url: " + jmxUrl);
                        break;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (connectingPid != -1) {
                this.context.print("Connecting to pid: " + connectingPid);
            } else {
                this.context.print("Connecting to JMX URL: " + jmxUrl);
            }
            this.setJmxServiceUrl(jmxUrl);
        }
        return this.getJmxServiceUrl();
    }

    protected void setJmxServiceUrl(JMXServiceURL jmxServiceUrl) {
        this.jmxServiceUrl = jmxServiceUrl;
    }

    protected void setJmxServiceUrl(String jmxServiceUrl) throws MalformedURLException {
        this.setJmxServiceUrl(new JMXServiceURL(jmxServiceUrl));
    }

    public String getJmxUser() {
        return jmxUser;
    }

    public void setJmxUser(String jmxUser) {
        AbstractJmxCommand.jmxUser = jmxUser;
    }

    public String getJmxPassword() {
        return jmxPassword;
    }

    public void setJmxPassword(String jmxPassword) {
        AbstractJmxCommand.jmxPassword = jmxPassword;
    }

    public boolean isJmxUseLocal() {
        return jmxUseLocal;
    }

    public void setJmxUseLocal(boolean jmxUseLocal) {
        AbstractJmxCommand.jmxUseLocal = jmxUseLocal;
    }

    private JMXConnector createJmxConnector() throws IOException {
        if (this.jmxConnector != null) {
            this.jmxConnector.connect();
            return this.jmxConnector;
        }
        if (jmxUser != null && jmxPassword != null) {
            HashMap<String, String[]> props = new HashMap<String, String[]>();
            props.put("jmx.remote.credentials", new String[]{jmxUser, jmxPassword});
            this.jmxConnector = JMXConnectorFactory.connect(this.useJmxServiceUrl(), props);
        } else {
            this.jmxConnector = JMXConnectorFactory.connect(this.useJmxServiceUrl());
        }
        return this.jmxConnector;
    }

    protected void closeJmxConnection() {
        try {
            if (this.jmxConnector != null) {
                this.jmxConnector.close();
                this.jmxConnector = null;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    protected MBeanServerConnection createJmxConnection() throws IOException {
        if (this.jmxConnection == null) {
            this.jmxConnection = this.isJmxUseLocal() ? ManagementFactory.getPlatformMBeanServer() : this.createJmxConnector().getMBeanServerConnection();
        }
        return this.jmxConnection;
    }

    @Override
    protected void handleOption(String token, List<String> tokens) throws Exception {
        if (token.equals("--jmxurl")) {
            if (tokens.isEmpty() || tokens.get(0).startsWith("-")) {
                this.context.printException(new IllegalArgumentException("JMX URL not specified."));
            }
            if (this.getJmxServiceUrl() != null) {
                this.context.printException(new IllegalArgumentException("Multiple JMX URL cannot be specified."));
                tokens.clear();
            }
            String strJmxUrl = tokens.remove(0);
            try {
                this.setJmxServiceUrl(new JMXServiceURL(strJmxUrl));
            }
            catch (MalformedURLException e) {
                this.context.printException(e);
                tokens.clear();
            }
        } else if (token.equals("--pid")) {
            if (AbstractJmxCommand.isSunJVM()) {
                if (tokens.isEmpty() || tokens.get(0).startsWith("-")) {
                    this.context.printException(new IllegalArgumentException("pid not specified"));
                    return;
                }
                int pid = Integer.parseInt(tokens.remove(0));
                this.context.print("Connecting to pid: " + pid);
                String jmxUrl = this.findJMXUrlByProcessId(pid);
                if (jmxUrl != null) {
                    if (this.getJmxServiceUrl() != null) {
                        this.context.printException(new IllegalArgumentException("JMX URL already specified."));
                        tokens.clear();
                    }
                    try {
                        this.setJmxServiceUrl(new JMXServiceURL(jmxUrl));
                    }
                    catch (MalformedURLException e) {
                        this.context.printException(e);
                        tokens.clear();
                    }
                } else {
                    this.context.printInfo("failed to resolve jmxUrl for pid:" + pid + ", using default JMX url");
                }
            } else {
                this.context.printInfo("--pid option is not available for this VM, using default JMX url");
            }
        } else if (token.equals("--jmxuser")) {
            if (tokens.isEmpty() || tokens.get(0).startsWith("-")) {
                this.context.printException(new IllegalArgumentException("JMX user not specified."));
            }
            this.setJmxUser(tokens.remove(0));
        } else if (token.equals("--jmxpassword")) {
            if (tokens.isEmpty() || tokens.get(0).startsWith("-")) {
                this.context.printException(new IllegalArgumentException("JMX password not specified."));
            }
            this.setJmxPassword(tokens.remove(0));
        } else if (token.equals("--jmxlocal")) {
            this.setJmxUseLocal(true);
        } else {
            super.handleOption(token, tokens);
        }
    }

    @Override
    public void execute(List<String> tokens) throws Exception {
        try {
            super.execute(tokens);
        }
        catch (Exception exception) {
            this.handleException(exception, this.jmxServiceUrl.toString());
            return;
        }
        finally {
            this.closeJmxConnection();
        }
    }
}

