/*
 * Decompiled with CFR 0.152.
 */
package com.primeton.pmq.console.command;

import com.primeton.ext.common.l7e.Imprimatur;
import com.primeton.ext.common.l7e.ImprimaturContext;
import com.primeton.ext.common.l7e.ImprimaturMgr;
import com.primeton.pmq.broker.BrokerFactory;
import com.primeton.pmq.broker.BrokerService;
import com.primeton.pmq.console.command.AbstractCommand;
import java.net.URI;
import java.util.List;
import java.util.concurrent.CountDownLatch;

public class StartCommand
extends AbstractCommand {
    public static final String DEFAULT_CONFIG_URI = "xbean:pmq.xml";
    private static final String ProductFamily = "Primeton MQ";
    protected String[] helpFile = new String[]{"Task Usage: Main start [start-options] [uri]", "Description: Creates and starts a broker using a configuration file, or a broker URI.", "", "Start Options:", "    -D<name>=<value>      Define a system property.", "    --version             Display the version information.", "    -h,-?,--help          Display the start broker help information.", "", "URI:", "", "    XBean based broker configuration:", "", "        Example: Main xbean:file:pmq.xml", "            Loads the xbean configuration file from the current working directory", "        Example: Main xbean:pmq.xml", "            Loads the xbean configuration file from the classpath", "", "    URI Parameter based broker configuration:", "", "        Example: Main broker:(tcp://localhost:61616, tcp://localhost:5000)?useJmx=true", "            Configures the broker with 2 transport connectors and jmx enabled", "        Example: Main broker:(tcp://localhost:61616, network:tcp://localhost:5000)?persistent=false", "            Configures the broker with 1 transport connector, and 1 network connector and persistence disabled", ""};

    @Override
    public String getName() {
        return "start";
    }

    @Override
    public String getOneLineDescription() {
        return "Creates and starts a broker using a configuration file, or a broker URI.";
    }

    @Override
    protected void runTask(List<String> brokerURIs) throws Exception {
        try {
            String licensePath = System.getProperty("pmq.license") + "/primetonlicense.xml";
            System.out.println(licensePath);
            ImprimaturContext context = ImprimaturContext.getInstance();
            context.setImprimaturFilePath(licensePath);
            Imprimatur imprimatur = ImprimaturMgr.getImprimatur();
            imprimatur.validate();
            if (!ProductFamily.equals(imprimatur.getProductFamily())) {
                throw new RuntimeException("ProductFamily is not Primeton MQ\uff01\uff01\uff01");
            }
            if (!ImprimaturMgr.checkComponent((String)"ip", (String)"")) {
                throw new RuntimeException("Check Component 'ip' return false.");
            }
            if (!ImprimaturMgr.checkComponent((String)"mac", (String)"")) {
                throw new RuntimeException("Check Component 'mac' return false.");
            }
            System.out.println("Loaded license.");
        }
        catch (Throwable e) {
            System.out.println(e.getMessage());
            System.exit(1);
        }
        while (true) {
            BrokerService broker;
            try {
                URI configURI = brokerURIs.isEmpty() ? new URI(DEFAULT_CONFIG_URI) : new URI(brokerURIs.get(0));
                System.out.println("Loading message broker from: " + configURI);
                broker = BrokerFactory.createBroker(configURI);
                broker.start();
            }
            catch (Exception e) {
                this.context.printException(new RuntimeException("Failed to execute start task. Reason: " + e, e));
                throw e;
            }
            if (!broker.isSlave() && !broker.waitUntilStarted()) {
                throw new Exception(broker.getStartException());
            }
            final CountDownLatch shutdownLatch = new CountDownLatch(1);
            Thread jvmShutdownHook = new Thread(){

                @Override
                public void run() {
                    try {
                        broker.stop();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            };
            Runtime.getRuntime().addShutdownHook(jvmShutdownHook);
            broker.addShutdownHook(new Runnable(){

                @Override
                public void run() {
                    shutdownLatch.countDown();
                }
            });
            shutdownLatch.await();
            try {
                Runtime.getRuntime().removeShutdownHook(jvmShutdownHook);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (!broker.isRestartRequested()) break;
            System.out.println("Restarting broker");
        }
    }

    @Override
    protected void printHelp() {
        this.context.printHelp(this.helpFile);
    }
}

