/*
 * Decompiled with CFR 0.152.
 */
package com.primeton.pmq.console.filter;

import com.primeton.pmq.command.PMQBytesMessage;
import com.primeton.pmq.command.PMQDestination;
import com.primeton.pmq.command.PMQMapMessage;
import com.primeton.pmq.command.PMQMessage;
import com.primeton.pmq.command.PMQObjectMessage;
import com.primeton.pmq.command.PMQStreamMessage;
import com.primeton.pmq.command.PMQTextMessage;
import com.primeton.pmq.console.filter.QueryFilter;
import com.primeton.pmq.console.filter.ResultTransformFilter;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import javax.jms.JMSException;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.openmbean.CompositeDataSupport;

public class MapTransformFilter
extends ResultTransformFilter {
    public MapTransformFilter(QueryFilter next) {
        super(next);
    }

    @Override
    protected Object transformElement(Object object) throws Exception {
        try {
            Method method = this.getClass().getDeclaredMethod("transformToMap", object.getClass());
            return (Map)method.invoke((Object)this, object);
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }

    protected Map transformToMap(ObjectInstance obj) {
        return this.transformToMap(obj.getObjectName());
    }

    protected Map transformToMap(ObjectName objname) {
        Properties props = new Properties();
        Hashtable<String, String> objProps = objname.getKeyPropertyList();
        for (Object key : objProps.keySet()) {
            Object val = objProps.get(key);
            if (val == null) continue;
            props.setProperty(key.toString(), this.getDisplayString(val));
        }
        return props;
    }

    protected Map transformToMap(AttributeList list) {
        Properties props = new Properties();
        for (Attribute attrib : list) {
            if (attrib.getName().equals("Attribute:ObjectName:")) {
                props.putAll((Map<?, ?>)this.transformToMap((ObjectName)attrib.getValue()));
                continue;
            }
            if (attrib.getValue() == null) continue;
            props.setProperty(attrib.getName(), this.getDisplayString(attrib.getValue()));
        }
        return props;
    }

    protected Map transformToMap(PMQTextMessage msg) throws JMSException {
        Properties props = new Properties();
        props.putAll(this.transformToMap((PMQMessage)msg));
        if (msg.getText() != null) {
            props.setProperty("JMS_BODY_FIELD:JMSText", msg.getText());
        }
        return props;
    }

    protected Map transformToMap(PMQBytesMessage msg) throws JMSException {
        byte[] msgBody;
        Properties props = new Properties();
        props.putAll(this.transformToMap((PMQMessage)msg));
        long bodyLength = msg.getBodyLength();
        int i = 0;
        i = 0;
        while ((long)i < bodyLength / Integer.MAX_VALUE) {
            msgBody = new byte[Integer.MAX_VALUE];
            props.setProperty("JMS_BODY_FIELD:JMSBytes:" + (i + 1), new String(msgBody));
            ++i;
        }
        msgBody = new byte[(int)(bodyLength % Integer.MAX_VALUE)];
        props.setProperty("JMS_BODY_FIELD:JMSBytes:" + (i + 1), new String(msgBody));
        return props;
    }

    protected Map transformToMap(PMQObjectMessage msg) throws JMSException {
        Properties props = new Properties();
        props.putAll(this.transformToMap((PMQMessage)msg));
        if (msg.getObject() != null) {
            props.setProperty("JMS_BODY_FIELD:JMSObjectClass", msg.getObject().getClass().getName());
            props.setProperty("JMS_BODY_FIELD:JMSObjectString", this.getDisplayString(msg.getObject()));
        }
        return props;
    }

    protected Map transformToMap(PMQMapMessage msg) throws JMSException {
        Properties props = new Properties();
        props.putAll(this.transformToMap((PMQMessage)msg));
        Enumeration<String> e = msg.getMapNames();
        while (e.hasMoreElements()) {
            String key = e.nextElement();
            Object val = msg.getObject(key);
            if (val == null) continue;
            props.setProperty("JMS_BODY_FIELD:" + key, this.getDisplayString(val));
        }
        return props;
    }

    protected Map transformToMap(PMQStreamMessage msg) throws JMSException {
        Properties props = new Properties();
        props.putAll(this.transformToMap((PMQMessage)msg));
        props.setProperty("JMS_BODY_FIELD:JMSStreamMessage", this.getDisplayString(msg));
        return props;
    }

    protected Map<String, String> transformToMap(PMQMessage msg) throws JMSException {
        HashMap<String, String> props = new HashMap<String, String>();
        if (msg.getJMSCorrelationID() != null) {
            props.put("JMS_HEADER_FIELD:JMSCorrelationID", msg.getJMSCorrelationID());
        }
        props.put("JMS_HEADER_FIELD:JMSDeliveryMode", msg.getJMSDeliveryMode() == 2 ? "persistent" : "non-persistent");
        if (msg.getJMSDestination() != null) {
            props.put("JMS_HEADER_FIELD:JMSDestination", ((PMQDestination)msg.getJMSDestination()).getPhysicalName());
        }
        props.put("JMS_HEADER_FIELD:JMSExpiration", Long.toString(msg.getJMSExpiration()));
        props.put("JMS_HEADER_FIELD:JMSMessageID", msg.getJMSMessageID());
        props.put("JMS_HEADER_FIELD:JMSPriority", Integer.toString(msg.getJMSPriority()));
        props.put("JMS_HEADER_FIELD:JMSRedelivered", Boolean.toString(msg.getJMSRedelivered()));
        if (msg.getJMSReplyTo() != null) {
            props.put("JMS_HEADER_FIELD:JMSReplyTo", ((PMQDestination)msg.getJMSReplyTo()).getPhysicalName());
        }
        props.put("JMS_HEADER_FIELD:JMSTimestamp", Long.toString(msg.getJMSTimestamp()));
        if (msg.getJMSType() != null) {
            props.put("JMS_HEADER_FIELD:JMSType", msg.getJMSType());
        }
        if (msg.getOriginalDestination() != null) {
            props.put("JMS_CUSTOM_FIELD:OriginalDestination", msg.getOriginalDestination().getPhysicalName());
        }
        Enumeration e = msg.getPropertyNames();
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            if (msg.getObjectProperty(name) == null) continue;
            props.put("JMS_CUSTOM_FIELD:" + name, this.getDisplayString(msg.getObjectProperty(name)));
        }
        return props;
    }

    protected Map transformToMap(CompositeDataSupport data) {
        Properties props = new Properties();
        String typeName = data.getCompositeType().getTypeName();
        if (typeName.equals(PMQTextMessage.class.getName())) {
            props.setProperty("JMS_BODY_FIELD:Text", data.get("Text").toString());
        } else if (typeName.equals(PMQBytesMessage.class.getName())) {
            props.setProperty("JMS_BODY_FIELD:BodyLength", data.get("BodyLength").toString());
            props.setProperty("JMS_BODY_FIELD:BodyPreview", new String((byte[])data.get("BodyPreview")));
        } else if (typeName.equals(PMQMapMessage.class.getName())) {
            Map contentMap = (Map)data.get("ContentMap");
            for (String key : contentMap.keySet()) {
                props.setProperty("JMS_BODY_FIELD:" + key, contentMap.get(key).toString());
            }
        } else if (!(typeName.equals(PMQObjectMessage.class.getName()) || typeName.equals(PMQStreamMessage.class.getName()) || typeName.equals(PMQMessage.class.getName()))) {
            throw new IllegalArgumentException("Unrecognized composite data to transform. composite type: " + typeName);
        }
        props.setProperty("JMS_HEADER_FIELD:JMSCorrelationID", "" + data.get("JMSCorrelationID"));
        props.setProperty("JMS_HEADER_FIELD:JMSDestination", "" + data.get("JMSDestination"));
        props.setProperty("JMS_HEADER_FIELD:JMSMessageID", "" + data.get("JMSMessageID"));
        props.setProperty("JMS_HEADER_FIELD:JMSReplyTo", "" + data.get("JMSReplyTo"));
        props.setProperty("JMS_HEADER_FIELD:JMSType", "" + data.get("JMSType"));
        props.setProperty("JMS_HEADER_FIELD:JMSDeliveryMode", "" + data.get("JMSDeliveryMode"));
        props.setProperty("JMS_HEADER_FIELD:JMSExpiration", "" + data.get("JMSExpiration"));
        props.setProperty("JMS_HEADER_FIELD:JMSPriority", "" + data.get("JMSPriority"));
        props.setProperty("JMS_HEADER_FIELD:JMSRedelivered", "" + data.get("JMSRedelivered"));
        props.setProperty("JMS_HEADER_FIELD:JMSTimestamp", "" + data.get("JMSTimestamp"));
        props.setProperty("JMS_CUSTOM_FIELD:Properties", "" + data.get("Properties"));
        return props;
    }

    protected String getDisplayString(Object obj) {
        if (null == obj) {
            return "null";
        }
        if (obj != null && obj.getClass().isArray()) {
            Class<?> type = obj.getClass().getComponentType();
            if (!type.isPrimitive()) {
                obj = Arrays.asList((Object[])obj);
            } else {
                int len = Array.getLength(obj);
                if (0 == len) {
                    return "[]";
                }
                StringBuilder bldr = new StringBuilder();
                bldr.append("[");
                for (int i = 0; i <= len; ++i) {
                    bldr.append(Array.get(obj, i));
                    if (i + 1 >= len) {
                        return bldr.append("]").toString();
                    }
                    bldr.append(",");
                }
            }
        }
        return obj.toString();
    }
}

