/*
 * Decompiled with CFR 0.152.
 */
package com.primeton.pmq.console.util;

import com.primeton.pmq.console.filter.AmqMessagesQueryFilter;
import com.primeton.pmq.console.filter.GroupPropertiesViewFilter;
import com.primeton.pmq.console.filter.MapTransformFilter;
import com.primeton.pmq.console.filter.PropertiesViewFilter;
import com.primeton.pmq.console.filter.QueryFilter;
import com.primeton.pmq.console.filter.StubQueryFilter;
import com.primeton.pmq.console.filter.WildcardToMsgSelectorTransformFilter;
import java.net.URI;
import java.util.List;
import java.util.Set;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;

public final class AmqMessagesUtil {
    public static final String JMS_MESSAGE_HEADER_PREFIX = "JMS_HEADER_FIELD:";
    public static final String JMS_MESSAGE_CUSTOM_PREFIX = "JMS_CUSTOM_FIELD:";
    public static final String JMS_MESSAGE_BODY_PREFIX = "JMS_BODY_FIELD:";

    private AmqMessagesUtil() {
    }

    public static List getAllMessages(URI brokerUrl, Destination dest) throws Exception {
        return AmqMessagesUtil.getMessages(brokerUrl, dest, "");
    }

    public static List getMessages(URI brokerUrl, Destination dest, String selector) throws Exception {
        return AmqMessagesUtil.createMessageQueryFilter(brokerUrl, dest).query(selector);
    }

    public static List getMessages(ConnectionFactory connectionFactory, Destination dest, String selector) throws Exception {
        return AmqMessagesUtil.createMessageQueryFilter(connectionFactory, dest).query(selector);
    }

    public static List getMessages(URI brokerUrl, Destination dest, List selectors) throws Exception {
        return AmqMessagesUtil.createMessageQueryFilter(brokerUrl, dest).query(selectors);
    }

    public static List getMessages(ConnectionFactory connectionFactory, Destination dest, List selectors) throws Exception {
        return AmqMessagesUtil.createMessageQueryFilter(connectionFactory, dest).query(selectors);
    }

    public static List filterMessagesView(List messages, Set groupViews, Set attributeViews) throws Exception {
        return new PropertiesViewFilter(attributeViews, new GroupPropertiesViewFilter(groupViews, new MapTransformFilter(new StubQueryFilter(messages)))).query("");
    }

    public static QueryFilter createMessageQueryFilter(URI brokerUrl, Destination dest) {
        return new WildcardToMsgSelectorTransformFilter(new AmqMessagesQueryFilter(brokerUrl, dest));
    }

    public static QueryFilter createMessageQueryFilter(ConnectionFactory connectionFactory, Destination dest) {
        return new WildcardToMsgSelectorTransformFilter(new AmqMessagesQueryFilter(connectionFactory, dest));
    }
}

